% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreSet-class.R
\name{CoreSet}
\alias{CoreSet}
\title{CoreSet constructor}
\usage{
CoreSet(
  name,
  molecularProfiles = list(),
  sample = data.frame(),
  sensitivityInfo = data.frame(),
  sensitivityRaw = array(dim = c(0, 0, 0)),
  sensitivityProfiles = matrix(),
  sensitivityN = matrix(nrow = 0, ncol = 0),
  perturbationN = array(NA, dim = c(0, 0, 0)),
  curationSample = data.frame(),
  curationTissue = data.frame(),
  curationTreatment = data.frame(),
  treatment = data.frame(),
  datasetType = c("sensitivity", "perturbation", "both"),
  verify = TRUE,
  ...
)
}
\arguments{
\item{name}{A \code{character} string detailing the name of the dataset}

\item{molecularProfiles}{A \code{list} of SummarizedExperiment objects containing
molecular profiles for each molecular data type.}

\item{sample}{A \code{data.frame} containing the annotations for all the sample
profiled in the data set, across all data types. Must contain the mandatory
\code{sampleid} column which uniquely identifies each sample in the object.}

\item{sensitivityInfo}{A \code{data.frame} containing the information for the
sensitivity experiments. Must contain a 'sampleid' column with unique
identifiers to each sample, matching the \code{sample} object and a 'treatmentid'
columns with unique indenifiers for each treatment, matching the \code{treatment}
object.}

\item{sensitivityRaw}{A 3 Dimensional \code{array} contaning the raw drug
dose response data for the sensitivity experiments}

\item{sensitivityProfiles}{\code{data.frame} containing drug sensitivity profile
statistics such as IC50 and AUC}

\item{sensitivityN, perturbationN}{A \code{data.frame} summarizing the
available sensitivity/perturbation data}

\item{curationSample, curationTissue, curationTreatment}{A \code{data.frame} mapping
the names for samples, tissues and treatments used in the data set to
universal identifiers used between different CoreSet objects}

\item{treatment}{A \code{data.frame} containing annotations for all treatments
profiled in the dataset. Must contain the mandatory \code{treatmentid} column
which uniquely identifies each treatment in the object.}

\item{datasetType}{A \code{character(1)} string of 'sensitivity',
'preturbation', or 'both' detailing what type of data can be found in the
\code{CoreSet}, for proper processing of the data}

\item{verify}{\code{logical(1)}Should the function verify the CoreSet and
print out any errors it finds after construction?}

\item{...}{Catch and parse any renamed constructor arguments.}
}
\value{
An object of class \code{CoreSet}
}
\description{
A constructor that simplifies the process of creating CoreSets, as well
as creates empty objects for data not provided to the constructor. Only
objects returned by this constructor are expected to work with the CoreSet
methods.
}
\details{
\subsection{\strong{WARNING}:}{

Parameters to this function have been renamed!
\itemize{
\item cell is now sample
\item drug is now treatment
}
}
}
\examples{
data(clevelandSmall_cSet)
clevelandSmall_cSet

}
