% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreSet-accessors.R
\name{CoreSet-accessors}
\alias{CoreSet-accessors}
\alias{annotation,CoreSet-method}
\alias{annotation}
\alias{annotation<-,CoreSet,list-method}
\alias{annotation<-}
\alias{dateCreated,CoreSet-method}
\alias{dateCreated}
\alias{dateCreated<-,CoreSet,character-method}
\alias{dateCreated<-,CoreSet-method}
\alias{dateCreated<-}
\alias{name,CoreSet-method}
\alias{name}
\alias{name<-,CoreSet-method}
\alias{name<-,CoreSet,character-method}
\alias{name<-}
\alias{sampleInfo,CoreSet-method}
\alias{sampleInfo}
\alias{cellInfo,CoreSet-method}
\alias{cellInfo}
\alias{sampleInfo<-,CoreSet,data.frame-method}
\alias{sampleInfo<-}
\alias{cellInfo<-,CoreSet,data.frame-method}
\alias{cellInfo<-}
\alias{sampleNames,CoreSet-method}
\alias{sampleName,CoreSet-method}
\alias{sampleNames}
\alias{cellName,CoreSet-method}
\alias{cellNames}
\alias{sampleNames<-,CoreSet,character-method}
\alias{sampleNames<-,CoreSet,list-method}
\alias{sampleNames<-}
\alias{cellNames<-,CoreSet,list-method}
\alias{cellNames<-}
\alias{treatmentInfo,CoreSet-method}
\alias{treatmentInfo}
\alias{treatmentInfo<-,CoreSet,data.frame-method}
\alias{treatmentInfo<-}
\alias{treatmentNames,CoreSet-method}
\alias{treatmentNames}
\alias{treatmentNames<-,CoreSet,character-method}
\alias{treatmentNames<-}
\alias{curation,CoreSet-method}
\alias{curation}
\alias{curation<-,CoreSet,list-method}
\alias{curation<-}
\alias{datasetType,CoreSet-method}
\alias{datasetType}
\alias{datasetType<-,CoreSet,character-method}
\alias{datasetType<-}
\alias{molecularProfiles,CoreSet-method}
\alias{molecularProfiles}
\alias{molecularProfiles<-,CoreSet,character,character,matrix-method}
\alias{molecularProfiles<-,CoreSet,character,missing,matrix-method}
\alias{molecularProfiles<-,CoreSet,missing,missing,list-method}
\alias{molecularProfiles<-,CoreSet,missing,missing,MutliAssayExperiment-method}
\alias{molecularProfiles<-}
\alias{molecularProfiles<-,CoreSet,missing,missing,list_OR_MAE-method}
\alias{featureInfo,CoreSet-method}
\alias{featureInfo}
\alias{featureInfo<-,CoreSet,character,data.frame-method}
\alias{featureInfo<-,CoreSet,character,DataFrame-method}
\alias{featureInfo<-}
\alias{phenoInfo,CoreSet,character-method}
\alias{phenoInfo}
\alias{phenoInfo<-,CoreSet,character,data.frame-method}
\alias{phenoInfo<-,CoreSet,character,DataFrame-method}
\alias{phenoInfo<-}
\alias{fNames,CoreSet,character-method}
\alias{fNames}
\alias{fNames<-,CoreSet,character,character-method}
\alias{fNames<-}
\alias{mDataNames,CoreSet-method}
\alias{mDataNames}
\alias{mDataNames<-,CoreSet-method}
\alias{mDataNames<-,CoreSet,ANY-method}
\alias{mDataNames<-}
\alias{molecularProfilesSlot,CoreSet-method}
\alias{moleculerProfilesSlot,CoreSet-method}
\alias{molecularProfilesSlot}
\alias{molecularProfilesSlot<-,CoreSet,list_OR_MAE-method}
\alias{molecularProfilesSlot<-,CoreSet,list-method}
\alias{molecularProfilesSlot<-CoreSet,MultiAssayExperiment-method}
\alias{molecularProfilesSlot<-}
\alias{sensitivityInfo,CoreSet-method}
\alias{sensitivityInfo,CoreSet,missing-method}
\alias{sensitivityInfo,CoreSet,character-method}
\alias{sensitivityInfo<-,CoreSet,data.frame-method}
\alias{sensitivityInfo<-,CoreSet,missing,data.frame-method}
\alias{sensitvityInfo<-,CoreSet,character,data.frame-method}
\alias{sensitivityMeasures,CoreSet-method}
\alias{sensitivityMeasures<-,CoreSet,character-method}
\alias{sensitivityProfiles,CoreSet-method}
\alias{sensitivityProfiles<-,CoreSet,data.frame-method}
\alias{sensitivityRaw,CoreSet-method}
\alias{sensitivityRaw<-,CoreSet,array-method}
\alias{treatmentResponse,CoreSet-method}
\alias{treatmentResponse}
\alias{sensitivitySlot}
\alias{treatmentResponse<-,CoreSet,list_OR_LongTable-method}
\alias{treatmentResponse<-}
\alias{treamentResponse<-,CoreSet,list-method}
\alias{treatmentResponse<-,CoreSet,LongTable-method}
\alias{sensitivitySlot<-}
\alias{sensNumber,CoreSet-method}
\alias{sensNumber}
\alias{sensNumber<-,CoreSet,matrix-method}
\alias{sensNumber<-}
\alias{pertNumber,CoreSet-method}
\alias{pertNumber}
\alias{pertNumber<-,CoreSet,array-method}
\alias{pertNumber<-}
\title{Accessing and modifying information in a \code{CoreSet}}
\usage{
\S4method{annotation}{CoreSet}(object)

\S4method{annotation}{CoreSet,list}(object) <- value

\S4method{dateCreated}{CoreSet}(object)

\S4method{dateCreated}{CoreSet,character}(object) <- value

\S4method{name}{CoreSet}(object)

\S4method{name}{CoreSet}(object) <- value

\S4method{sampleInfo}{CoreSet}(object)

\S4method{sampleInfo}{CoreSet,data.frame}(object) <- value

\S4method{sampleNames}{CoreSet}(object)

\S4method{sampleNames}{CoreSet,character}(object) <- value

\S4method{treatmentInfo}{CoreSet}(object)

\S4method{treatmentInfo}{CoreSet,data.frame}(object) <- value

\S4method{treatmentNames}{CoreSet}(object)

\S4method{treatmentNames}{CoreSet,character}(object) <- value

\S4method{curation}{CoreSet}(object)

\S4method{curation}{CoreSet,list}(object) <- value

\S4method{datasetType}{CoreSet}(object)

\S4method{datasetType}{CoreSet,character}(object) <- value

\S4method{molecularProfiles}{CoreSet}(object, mDataType, assay)

\S4method{molecularProfiles}{CoreSet,character,character,matrix}(object, mDataType, assay) <- value

\S4method{molecularProfiles}{CoreSet,character,missing,matrix}(object, mDataType, assay) <- value

\S4method{molecularProfiles}{CoreSet,missing,missing,list_OR_MAE}(object, mDataType, assay) <- value

\S4method{featureInfo}{CoreSet}(object, mDataType)

\S4method{featureInfo}{CoreSet,character,data.frame}(object, mDataType) <- value

\S4method{phenoInfo}{CoreSet,character}(object, mDataType)

\S4method{phenoInfo}{CoreSet,character,data.frame}(object, mDataType) <- value

\S4method{fNames}{CoreSet,character}(object, mDataType)

\S4method{fNames}{CoreSet,character,character}(object, mDataType) <- value

\S4method{mDataNames}{CoreSet}(object)

\S4method{mDataNames}{CoreSet}(object) <- value

\S4method{molecularProfilesSlot}{CoreSet}(object)

\S4method{molecularProfilesSlot}{CoreSet,list_OR_MAE}(object) <- value

\S4method{sensitivityInfo}{CoreSet}(object, dimension, ...)

\S4method{sensitivityInfo}{CoreSet,data.frame}(object, dimension, ...) <- value

\S4method{sensitivityMeasures}{CoreSet}(object)

\S4method{sensitivityMeasures}{CoreSet,character}(object) <- value

\S4method{sensitivityProfiles}{CoreSet}(object)

\S4method{sensitivityProfiles}{CoreSet,data.frame}(object) <- value

\S4method{sensitivityRaw}{CoreSet}(object)

\S4method{sensitivityRaw}{CoreSet,array}(object) <- value

\S4method{treatmentResponse}{CoreSet}(object)

\S4method{treatmentResponse}{CoreSet,list_OR_LongTable}(object) <- value

\S4method{sensNumber}{CoreSet}(object)

\S4method{sensNumber}{CoreSet,matrix}(object) <- value

\S4method{pertNumber}{CoreSet}(object)

\S4method{pertNumber}{CoreSet,array}(object) <- value
}
\arguments{
\item{object}{A \code{CoreSet} object.}

\item{value}{See details.}

\item{mDataType}{\code{character(1)} The name of a molecular datatype to access
from the \code{molecularProfiles} of a \code{CoreSet} object.}

\item{assay}{\code{character(1)} A valid assay name in the \code{SummarizedExperiment}
of \verb{@molecularProfiles} of a CoreSet object for data type \code{mDataType}.}

\item{dimension}{See details.}

\item{...}{See details.}
}
\value{
Accessors: See details.

Setters: An updated \code{CoreSet} object, returned invisibly.
}
\description{
Documentation for the various setters and getters which allow manipulation
of data in the slots of a \code{CoreSet} object.
}
\details{
\subsection{@annotation}{

\strong{annotation}: A \code{list} of CoreSet annotations with items: 'name',
the name of the object; 'dateCreated', date the object was created; 'sessionInfo',
the \code{sessionInfo()} when the object was created; 'call', the R constructor call;
and 'version', the object version.
}

\strong{annotation<-}: Setter method for the annotation slot. Arguments:
\itemize{
\item value: a \code{list} of annotations to update the CoreSet with.
}

\subsection{@dateCreated}{

\strong{dateCreated}: \code{character(1)} The date the \code{CoreSet} object was
created, as returned by the \code{date()} function.
}

\strong{dateCreated<-}: Update the 'dateCreated' item in the \code{annotation} slot of
a \code{CoreSet} object. Arguments:
\itemize{
\item value: A \code{character(1)} vector, as returned by the \code{date()} function.
}

\strong{name}: \code{character(1)} The name of the \code{CoreSet}, retreived from
the \verb{@annotation} slot.

\strong{name<-}: Update the \verb{@annotation$name} value in a \code{CoreSet}  object.
\itemize{
\item value: \code{character(1)} The name of the \code{CoreSet} object.
}

\strong{cellInfo}: \code{data.frame} Metadata for all sample in a \code{CoreSet} object.

\strong{sampleInfo<-}: assign updated sample annotations to the \code{CoreSet}
object.
Arguments:
\itemize{
\item value: a \code{data.frame} object.
}

\strong{sampleNames}: \code{character} Retrieve the rownames of the \code{data.frame} in
the \code{sample} slot from a CoreSet object.

\strong{sampleNames<-}: assign new rownames to the sampleInfo \code{data.frame} for
a CoreSet object.
Arguments:
\itemize{
\item value: \code{character} vector of rownames for the \code{sampleInfo(object)} \code{data.frame}.
}

\strong{treatmentInfo}: \code{data.frame} Metadata for all treatments in a \code{CoreSet}
object. Arguments:
\itemize{
\item object: \code{CoreSet} An object to retrieve treatment metadata from.
}

\strong{treatmentInfo<-}: \code{CoreSet} object with updated treatment metadata.
object. Arguments:
\itemize{
\item object: \code{CoreSet} An object to set treatment metadata for.
\item value: \code{data.frame} A new table of treatment metadata for \code{object}.
}

\strong{treatmentNames}: \code{character} Names for all treatments in a \code{CoreSet}
object. Arguments:
\itemize{
\item object: \code{CoreSet} An object to retrieve treatment names from.
}

\strong{treatmentNames<-}: \code{CoreSet} Object with updates treatment names.
object. Arguments:
\itemize{
\item object: \code{CoreSet} An object to set treatment names from.
\item value: \code{character} A character vector of updated treatment names.
}

\subsection{@curation}{

\strong{curation}: A \code{list} of curated mappings between identifiers in the
CoreSet object and the original data publication. Contains two \code{data.frame}s, 'sample' with sample ids and
'tissue' with tissue ids.
}

\strong{curation<-}: Update the \code{curation} slot of a CoreSet object. Arugments:
\itemize{
\item value: A \code{list} of \code{data.frame}s, one for each type of curated
identifier. For a \code{CoreSet} object the slot should contain tissue and
sample id \code{data.frame}s.
}

\subsection{datasetType slot}{

\strong{datasetType}: \code{character(1)} The type treatment response in the
\code{sensitivity} slot. Valid values are 'sensitivity', 'perturbation' or 'both'.
}

\strong{datasetType<-}: Update the datasetType slot of a CoreSet object.
Arguments:
\itemize{
\item value: A \code{character(1)} vector with one of 'sensitivity', 'perturbation'
or 'both'
}

\subsection{@molecularProfiles}{

\strong{molecularProfiles}: \code{matrix()} Retrieve an assay in a
\code{SummarizedExperiment} from the \code{molecularProfiles} slot of a \code{CoreSet}
object with the specified \code{mDataType}. Valid \code{mDataType} arguments can be
found with \code{mDataNames(object)}. Exclude \code{mDataType} and \code{assay} to
access the entire slot. Arguments:
\itemize{
\item assay: Optional \code{character(1)} vector specifying an assay in the
\code{SummarizedExperiment} of the \code{molecularProfiles} slot of the
\code{CoreSet} object for the specified \code{mDataType}. If excluded,
defaults to modifying the first assay in the \code{SummarizedExperiment} for
the given \code{mDataType}.
}
}

\strong{molecularProfiles<-}: Update an assay in a \code{SummarizedExperiment} from
the \code{molecularProfiles} slot of a CoreSet object with the specified
\code{mDataType}. Valid \code{mDataType} arguments can be found with
\code{mDataNames(object)}. Omit \code{mDataType} and \code{assay} to update the slot.
\itemize{
\item assay: Optional \code{character(1)} vector specifying an assay in the
\code{SummarizedExperiment} of the \code{molecularProfiles} slot of the
\code{CoreSet} object for the specified \code{mDataType}. If excluded,
defaults to modifying the first assay in the \code{SummarizedExperiment} for
the given \code{mDataType}.
\item value: A \code{matrix} of values to assign to the \code{assay} slot of the
\code{SummarizedExperiment} for the selected \code{mDataType}. The rownames and
column names must match the associated \code{SummarizedExperiment}.
}

\strong{featureInfo}: Retrieve a \code{DataFrame} of feature metadata for the specified
\code{mDataType} from the \code{molecularProfiles} slot of a \code{CoreSet} object. More
specifically, retrieve the \verb{@rowData} slot from the \code{SummarizedExperiment}
from the \verb{@molecularProfiles} of a \code{CoreSet} object with the name
\code{mDataType}.

\strong{featureInfo<-}: Update the \code{featureInfo(object, mDataType)} \code{DataFrame}
with new feature metadata. Arguments:
\itemize{
\item value: A \code{data.frame} or \code{DataFrame} with updated feature metadata for
the specified molecular profile in the \code{molecularProfiles} slot of a
\code{CoreSet} object.
}

\strong{phenoInfo}: Return the \verb{@colData} slot from the \code{SummarizedExperiment} of
\code{mDataType}, containing sample-level metadata, from a \code{CoreSet} object.

\strong{phenoInfo<-}: Update the \verb{@colData} slot of the \code{SummarizedExperiment}
of \code{mDataType} in the \verb{@molecularProfiles} slot of a \code{CoreSet} object.
This updates the sample-level metadata in-place.
\itemize{
\item value: A \code{data.frame} or \code{DataFrame} object where rows are samples
and columns are sample metadata.
}

\strong{fNames}: \code{character()} The features names from the \code{rowData} slot of a
\code{SummarizedExperiment} of \code{mDataType} within a \code{CoreSet} object.

\strong{fNames}: Updates the rownames of the feature metadata (i.e., \code{rowData})
for a \code{SummarizedExperiment} of \code{mDataType} within a \code{CoreSet} object.
\itemize{
\item value: \code{character()} A character vector of new features names for the
\code{rowData} of the \code{SummarizedExperiment} of \code{mDataType} in the
\verb{@molecularProfiles} slot of a \code{CoreSet} object. Must be the same
length as \code{nrow(featureInfo(object, mDataType))},
the number of rows in the feature metadata.
}

\strong{mDataNames}: \code{character} Retrieve the names of the molecular data types
available in the \code{molecularProfiles} slot of a \code{CoreSet} object. These
are the options which can be used in the \code{mDataType} parameter of various
\code{molecularProfiles} slot accessors methods.

\strong{mDataNames}: Update the molecular data type names of the
\code{molecularProfiles} slot of a CoreSet object. Arguments:
\itemize{
\item value: \code{character} vector of molecular datatype names, with length
equal to \code{length(molecularProfilesSlot(object))}.
}

\strong{molecularProfilesSlot}: Return the contents of the \verb{@molecularProfiles}
slot of a \code{CoreSet} object. This will either be a \code{list} or
\code{MultiAssayExperiment} of \code{SummarizedExperiment}s.

\strong{molecularProfilesSlot<-}: Update the contents of the \verb{@molecularProfiles}
slot of a \code{CoreSet} object. Arguemnts:
\itemize{
\item value: A \code{list} or \code{MultiAssayExperiment} of \code{SummarizedExperiment}s. The
\code{list} and \code{assays} should be named for the molecular datatype in each
\code{SummarizedExperiment}.
}

\subsection{@treatmentResponse}{
\subsection{Arguments:}{
\itemize{
\item \code{dimension}: Optional \code{character(1)} One of 'treatment', 'sample' or
'assay' to retrieve \code{rowData}, \code{colData} or the 'assay_metadata' assay from
the \code{CoreSet} \verb{@sensitvity} \code{LongTable} object, respectively. Ignored with
warning if \verb{@treatmentResponse} is not a \code{LongTable} object.
\item \code{...}: Additional arguments to the \code{rowData} or \code{colData}.
\code{LongTable} methods. Only used if the sensitivity slot contains a
\code{LongTable} object instead of a \code{list} and the \code{dimension} argument is
specified.
}
}

\subsection{Methods:}{

\strong{sensitivityInfo}: \code{DataFrame} or \code{data.frame} of sensitivity treatment combo
by sample metadata for the \code{CoreSet} object. When the \code{dimension}
parameter is used, it allows retrieval of the dimension specific metadata
from the \code{LongTable} object in \verb{@treatmentResponse} of a CoreSet object.
}

}

\strong{sensitivityInfo}<-: Update the \verb{@treatmentResponse} slot metadata for a
\code{CoreSet} object. When used without the \code{dimension} argument is behaves
similar to the old CoreSet implementation, where the \verb{@treatmentResponse} slot
contained a list with a \verb{$info} \code{data.frame} item. When the \code{dimension}
arugment is used, more complicated assignments can occur where 'sample'
modifies the \verb{@sensitvity} \code{LongTable} colData, 'treatment' the rowData and
'assay' the 'assay_metadata' assay.
Arguments:
\itemize{
\item value: A \code{data.frame} of treatment response experiment metadata,
documenting experiment level metadata (mapping to treatments and samples). If
the \verb{@treatmentResponse} slot doesn't contain a \code{LongTable} and \code{dimension} is
not specified, you can only modify existing columns as returned by
\code{sensitivityInfo(object)}.
}

\strong{sensitivityMeaures}: Get the 'sensitivityMeasures' available in a \code{CoreSet}
object. Each measure reprents some summary of sample sensitivity to a given
treatment, such as ic50, ec50, AUC, AAC, etc. The results are returned as a
\code{character} vector with all available metrics for the PSet object.

\strong{sensitivityMeaures}: Update the sensitivity meaure in a \code{CoreSet}
object. Thesee values are the column names of the 'profiles' assay and
represent various compued sensitviity metrics such as ic50, ec50, AUC, AAC,
etc.
\itemize{
\item value: A \code{character} vector of new sensitivity measure names, the
then length of the character vector must matcht he number of columns of the
'profiles' assay, excluding metadata and key columns.
}

\strong{sensitivityProfiles}: Return the sensitivity profile summaries from the
sensitivity slot. This data.frame cotanins vaarious sensitivity summary
metrics, such as ic50, amax, EC50, aac, HS, etc as columns, with rows as
treatment by sample experiments.

\strong{sensitivityProfiles<-}: Update the sensitivity profile summaries the
sensitivity slot. Arguments:
-value: A \code{data.frame} the the same number of rows as as returned by
\code{sensitivityProfiles(object)}, but potentially modified columns, such as the
computation of additional summary metrics.

\strong{sensitivityRaw}: Access the raw sensitiity measurents for a CoreSet
object. A 3D \code{array} where rows are experiment_ids, columns are doses
and the third dimension is metric, either 'Dose' for the doses used or
'Viability' for the sample viability at that dose.

\strong{sensitvityRaw<-}: Update the raw dose and viability data in a \code{CoreSet}.
\itemize{
\item value: A 3D \code{array} object where rows are experiment_ids, columns are
replicates and pages are c('Dose', 'Viability'), with the corresponding
dose or viability measurement for that experiment_id and replicate.
}

\strong{sensNumber}: Return a count of viability observations in a \code{CoreSet}
object for each treatment-combo by sample combination.

\strong{sensNumber<-}: Update the 'n' item, which holds a matrix with a count
of treatment by sample-line experiment counts, in the \code{list} in \verb{@treatmentResponse}
slot of a \code{CoreSet} object. Will error when \verb{@sensitviity} contains
a \code{LongTable} object, since the counts are computed on the fly. Arguments:
\itemize{
\item value: A \code{matrix} where rows are samples and columns are treatments, with a
count of the number of experiments for each combination as the values.
}

\strong{pertNumber}: \code{array} Summary of available perturbation experiments
from in a \code{CoreSet} object. Returns a 3D \code{array} with the number of
perturbation experiments per treatment and sample, and data type.

\strong{pertNumber<-}: Update the \verb{@perturbation$n} value in a \code{CoreSet} object,
which stores a summary of the available perturbation experiments. Arguments:
\itemize{
\item value: A new 3D \code{array} with the number of perturbation experiments per
treatment and sample, and data type
}
}
\examples{
data(clevelandSmall_cSet)

## @annotation

annotation(clevelandSmall_cSet)

annotation(clevelandSmall_cSet) <- annotation(clevelandSmall_cSet)

dateCreated(clevelandSmall_cSet)

## dateCreated
dateCreated(clevelandSmall_cSet) <- date()

name(clevelandSmall_cSet)

name(clevelandSmall_cSet) <- 'new_name'

sampleInfo(clevelandSmall_cSet) <- sampleInfo(clevelandSmall_cSet)

sampleNames(clevelandSmall_cSet)

sampleNames(clevelandSmall_cSet) <- sampleNames(clevelandSmall_cSet)

treatmentInfo(clevelandSmall_cSet)

treatmentInfo(clevelandSmall_cSet) <- treatmentInfo(clevelandSmall_cSet)

treatmentNames(clevelandSmall_cSet)

treatmentNames(clevelandSmall_cSet) <- treatmentNames(clevelandSmall_cSet)

## curation
curation(clevelandSmall_cSet)

curation(clevelandSmall_cSet) <- curation(clevelandSmall_cSet)

datasetType(clevelandSmall_cSet)

datasetType(clevelandSmall_cSet) <- 'both'

# No assay specified
molecularProfiles(clevelandSmall_cSet, 'rna') <- molecularProfiles(clevelandSmall_cSet, 'rna')

# Specific assay
molecularProfiles(clevelandSmall_cSet, 'rna', 'exprs') <-
    molecularProfiles(clevelandSmall_cSet, 'rna', 'exprs')

# Replace the whole slot
molecularProfiles(clevelandSmall_cSet) <- molecularProfiles(clevelandSmall_cSet)

featureInfo(clevelandSmall_cSet, 'rna')

featureInfo(clevelandSmall_cSet, 'rna') <- featureInfo(clevelandSmall_cSet, 'rna')

phenoInfo(clevelandSmall_cSet, 'rna')

phenoInfo(clevelandSmall_cSet, 'rna') <- phenoInfo(clevelandSmall_cSet, 'rna')

fNames(clevelandSmall_cSet, 'rna')

fNames(clevelandSmall_cSet, 'rna') <- fNames(clevelandSmall_cSet, 'rna')

mDataNames(clevelandSmall_cSet)

mDataNames(clevelandSmall_cSet) <- mDataNames(clevelandSmall_cSet)

molecularProfilesSlot(clevelandSmall_cSet)

molecularProfilesSlot(clevelandSmall_cSet) <- molecularProfilesSlot(clevelandSmall_cSet)

sensitivityInfo(clevelandSmall_cSet)

sensitivityInfo(clevelandSmall_cSet) <- sensitivityInfo(clevelandSmall_cSet)

sensitivityMeasures(clevelandSmall_cSet) <- sensitivityMeasures(clevelandSmall_cSet)

sensitivityMeasures(clevelandSmall_cSet) <- sensitivityMeasures(clevelandSmall_cSet)

sensitivityProfiles(clevelandSmall_cSet)

sensitivityProfiles(clevelandSmall_cSet) <- sensitivityProfiles(clevelandSmall_cSet)

head(sensitivityRaw(clevelandSmall_cSet))

sensitivityRaw(clevelandSmall_cSet) <- sensitivityRaw(clevelandSmall_cSet)

treatmentResponse(clevelandSmall_cSet)

treatmentResponse(clevelandSmall_cSet) <- treatmentResponse(clevelandSmall_cSet)

sensNumber(clevelandSmall_cSet)

sensNumber(clevelandSmall_cSet) <- sensNumber(clevelandSmall_cSet)

pertNumber(clevelandSmall_cSet)

pertNumber(clevelandSmall_cSet) <- pertNumber(clevelandSmall_cSet)

}
