% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSNPData.R
\name{loadSNPData}
\alias{loadSNPData}
\title{loadSNPData}
\usage{
loadSNPData(snp.data, chr.col = NULL, start.col = NULL, end.col = NULL, pos.col = NULL, baf.col = NULL, lrr.col = NULL, id.col = NULL, genome = NULL, verbose = TRUE)
}
\arguments{
\item{snp.data}{Either the name of the file with the data or a variable containing the data.}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to NULL)}

\item{start.col}{(number or character) the name or number of the column with start position}

\item{end.col}{(number or character) the name of number of the column with end position}

\item{pos.col}{(number or character) The name or number of the column with position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{baf.col}{(number or character) The name or number of the column with BAF information. If NULL, it is automatically identified. (defaults to NULL)}

\item{lrr.col}{(number or character) The name or number of the column with LRR information. If NULL, it is automatically identified. (defaults to NULL)}

\item{id.col}{(number or character) The name or number of the column with SNP identifier information. If NULL, it is automatically identified. (defaults to NULL)}

\item{genome}{(character) The name of the genome (defaults to "hg19")}

\item{verbose}{Wether information messages should be generated. (defaults to TRUE)}
}
\value{
A GRanges with a range per SNP
}
\description{
Loads SNP array data in a tabular format
}
\details{
Given a file name or data in a tabular format,
the function loads SNP array data in a tabular format.
It will try to identify the columns with the relevant information
(chr, position, BAF, LRR, etc...) or will use the column number or name
supplied by the user, if any. It will convert the tabular data into a
GRanges, with one range per SNP in the table.
}
\examples{

# There are two examples of posible files to load.
snp.data1 <- system.file("extdata", "snp.data_test.csv", package = "CopyNumberPlots", mustWork=TRUE)
snps <- loadSNPData(snp.data = snp.data1)

snp.data2 <-  system.file("extdata", "snp.data_test2.csv", package = "CopyNumberPlots", mustWork=TRUE)
snps <- loadSNPData(snp.data = snp.data2)

}
