% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCallsSeg.R
\name{loadCopyNumberCallsSeg}
\alias{loadCopyNumberCallsSeg}
\title{loadCopyNumberCallsSeg}
\usage{
loadCopyNumberCallsSeg (seg.file, chr.col = "chrom", start.col = "loc.start", end.col = "loc.end", segment.value.col = "seg.mean", cn.col = NULL, genome = NULL, chr.transformation = "23:X,24:Y,25:MT", verbose = TRUE)
}
\arguments{
\item{seg.file}{The name of the file with the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to "chrom")}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to "loc.start")}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to "loc.end")}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. If NULL, it is automatically identified. (defaults to "seg.mean")}

\item{cn.col}{(number or character)The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to NULL)}

\item{genome}{(character) The name of the genome (defaults to NULL)}

\item{chr.transformation}{(character)(character) The transformation of the chromosome names in a comma separated "key:value" format as detailed at https://cnvkit.readthedocs.io/en/stable/importexport.html#import-seg.(defaults to "23:X,24:Y,25:MT")}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment
}
\description{
Loads copy number calls from .seg file format
}
\details{
This function will load segments data from .seg file format. 
Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files. 
If no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{
## loadCopyNumberCallsSeg from .seg file format: 
## the file to run in the example can be found in:
## https://software.broadinstitute.org/software/igv/SEG
## under example.seg file name.

seg.file <- system.file("extdata", "DNACopy_output.seg", package = "CopyNumberPlots", mustWork = TRUE)
cnv.call <- loadCopyNumberCallsSeg(seg.file = seg.file)

}
