% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCalls.R
\name{loadCopyNumberCalls}
\alias{loadCopyNumberCalls}
\title{loadCopyNumberCalls}
\usage{
loadCopyNumberCalls(cnv.data, chr.col = NULL, start.col = NULL, end.col = NULL, cn.col = NULL, loh.col = NULL, segment.value.col = NULL, genome = NULL, zero.based = FALSE, verbose = TRUE)
}
\arguments{
\item{cnv.data}{Either the name of the file with the data or a variable containing the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to NULL)}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to NULL)}

\item{cn.col}{(number or character) The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to NULL)}

\item{loh.col}{(number or character) The name or number of the column with LOH information. If NULL, it is automatically identified. (defaults to NULL)}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. If NULL, it is automatically identified. (defaults to NULL)}

\item{genome}{(character) The name of the genome (defaults to NULL)}

\item{zero.based}{(logical) Whether the data is zero-based and half open (i.e. ranges are defined by (start:end] so chr1:10-20 represents nine bases long features spanning from base 11 to 20). (defaults to FALSE)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment
}
\description{
Loads copy number calls from a tabular format
}
\details{
This function will load segments data from any "bed-like" data structure
in R or file. Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files.
If no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{
df <- data.frame("id"= "rs1234","chromosome"="chr1", "Start"=0, "end.position"=100,
"copy.number.level"=3, "LOH"=0, "median.value.per.segment"=1.2,
"BAF"=0.2, "Log Ratio"=1.5, "strange.name"="strange.value")

cnv.call <- loadCopyNumberCalls(cnv.data = df) 

}
