% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompDb.R
\name{addJoinDefinition}
\alias{addJoinDefinition}
\title{Expand a CompDb database with additional, related tables}
\usage{
addJoinDefinition(
  x,
  table_a = character(),
  table_b = character(),
  column_a = character(),
  column_b = character(),
  join = "left outer join"
)
}
\arguments{
\item{x}{\code{CompDb} to which the join definition should be added.}

\item{table_a}{\code{character(1)} with the name of one of the two tables that
are related to each other (and can be joined).}

\item{table_b}{\code{character(1)} with the name of the second of the two tables
that are related to each other (and can be joined).}

\item{column_a}{\code{character(1)} with the name of the column in \code{table_a}
containing the keys for the relationship to table \code{table_b}.}

\item{column_b}{\code{character(1)} with the name of the column in \code{table_b}
containing the keys for the relationship to table \code{table_a}.}

\item{join}{\code{character(1)} with the type of join. Defaults to
\code{join = "left outer join"}.}
}
\value{
The input \code{CompDb} with tha added information on how to join the
respective database tables.
}
\description{
The \code{CompDb} object uses a simple relational database model that consists of
the following database tables, some of which are optional:
\itemize{
\item \emph{ms_compound}: annotation(s) of compounds.
\item \emph{metadata}: general metadata information on the database. This database
table is \strong{not} related to any other table in the database and its
content is thus also not joined with other database tables.
\item \emph{synonym} (optional): database table containing optional additional
synonym(s) for compounds in the \emph{ms_compound} table. Rows in this table
are linked to a row in \emph{ms_compound} through the \code{"compound_id"} database
table column.
\item \emph{msms_spectrum} (optional): database table with information on individual
mass spectra (each row containing the metadata for one spectrum). Database
table column \code{"compound_id"} links entries in this database table to a
single row in the \emph{ms_compound} table.
\item \emph{msms_spectrum_peak} (otional): database table containing mass peak data.
Each row in this table is related to one row in the \emph{msms_spectrum} table
(through the \code{"spectrum_id"} column present in both tables).
}

In addition, the \code{CompDb} database layout can be extended by adding
additional tables. To make their content automatically available through
the built-in \code{\link[=compounds]{compounds()}} or \code{Spectra()} functions, the
information on how to combine/join these tables with the existing ones
needs to be provided.
This can be done using the \code{addJoinDefinition()} function: the relationship
of a new table with one of the existing tables can be defined with
this function providing the names of the two database tables as well as the
names of the columns containing the primary/foreign keys defining the
the relationship.

See the section \emph{Extending CompDb databases} in the \emph{Creating
CompoundDb annotation resources} package vignette for a detailed example.
}
\examples{

## The pre-defined table join definitions:
CompoundDb:::.JOINS

## See section "Extending CompDb databases" in the *Creating CompoundDb
## annotation resources* package vignette for examples

}
\author{
Johannes Rainer
}
