% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CogapsParams.R, R/methods-CogapsParams.R
\docType{methods}
\name{setDistributedParams}
\alias{setDistributedParams}
\alias{setDistributedParams,CogapsParams-method}
\title{set the value of parameters for distributed CoGAPS}
\usage{
setDistributedParams(
  object,
  nSets = NULL,
  cut = NULL,
  minNS = NULL,
  maxNS = NULL
)

\S4method{setDistributedParams}{CogapsParams}(
  object,
  nSets = NULL,
  cut = NULL,
  minNS = NULL,
  maxNS = NULL
)
}
\arguments{
\item{object}{an object of type CogapsParams}

\item{nSets}{number of sets to break data into}

\item{cut}{number of branches at which to cut dendrogram used in
pattern matching}

\item{minNS}{minimum of individual set contributions a cluster must contain}

\item{maxNS}{maximum of individual set contributions a cluster can contain}
}
\value{
the modified params object
}
\description{
these parameters  are interrelated so they must be set together
}
\examples{
 params <- new("CogapsParams", nPatterns=3)
 params <- setDistributedParams(params, 5)
}
