% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{showData}
\alias{showData}
\alias{showData,ClustAllObject-method}
\title{Retrieve Processed Data from ClustAllObject}
\usage{
showData(Object)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}}.}
}
\value{
A data frame containing the processed data used for clustering analysis.
This data reflects all preprocessing steps applied during object creation but
does not include any imputation that may have been performed.
}
\description{
This method extracts and returns the processed data stored in a ClustAllObject.
The data returned is the version used for clustering analysis, which has undergone
preprocessing steps such as one-hot encoding for categorical variables and
removal of the validation column (if present).
}
\details{
The showData method provides access to the core dataset used in the ClustALL
analysis pipeline. Key aspects of this data include:

\enumerate{
  \item Preprocessing Applied:
  \itemize{
    \item Categorical variables have been converted to numeric form via one-hot encoding.
    \item The validation column (if specified during object creation) has been removed.
  }

  \item Data Structure:
  \itemize{
    \item All columns are numeric, suitable for use in clustering algorithms.
    \item Row order corresponds to the original input data.
  }

  \item Missing Data:
  \itemize{
    \item The returned data may still contain missing values (NAs) if imputation
          was not performed.
    \item For imputed versions of the data, use the \code{\link{dataImputed}} method.
  }
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=-ID)
obj_noNA <- createClustAll(data = wdbc, colValidation = "Diagnosis")
showData(obj_noNA)
}
\seealso{
\code{\link{createClustAll}}, \code{\link{dataOriginal}},
\code{\link{dataImputed}}, \code{\link{ClustAllObject-class}}
}
