% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{dataOriginal}
\alias{dataOriginal}
\alias{dataOriginal,ClustAllObject-method}
\title{Retrieve Original Unprocessed Data from ClustAllObject}
\usage{
dataOriginal(Object)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}}.}
}
\value{
A data frame containing the original, unprocessed input data exactly
as it was provided when creating the ClustAllObject.
}
\description{
This method extracts and returns the original, unmodified data that was used
to create the ClustAllObject. It provides access to the raw input data before
any preprocessing steps were applied, including one-hot encoding, validation
column removal, or imputation.
}
\details{
The dataOriginal method serves as a reference point for the initial state of
the data in the ClustALL analysis pipeline. Key aspects of this data include:

\enumerate{
  \item Data Integrity:
  \itemize{
    \item Contains all original variables, including any that may have been removed
          or transformed during preprocessing.
    \item Preserves original data types (e.g., factors for categorical variables).
    \item Includes the validation column if it was present in the original data.
  }

  \item Missing Data:
  \itemize{
    \item Reflects the original state of missing values (NAs) in the dataset.
  }

  \item Data Structure:
  \itemize{
    \item Maintains the original row and column order of the input data.
    \item No transformations or encodings have been applied.
  }
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=-ID)
obj_noNA <- createClustAll(data = wdbc, colValidation = "Diagnosis")
dataOriginal(obj_noNA)
}
\seealso{
\code{\link{createClustAll}}, \code{\link{showData}},
\code{\link{dataImputed}}, \code{\link{ClustAllObject-class}}
}
