% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{findFragment}
\alias{findFragment}
\title{Find spectra that contain a specific fragment}
\usage{
findFragment(featlist, mz, tolerance = 1e-05)
}
\arguments{
\item{featlist}{a list that contains only objects of class
\code{\linkS4class{MS2spectrum}}}

\item{mz}{The mass-to-charge ratio of the fragment ion of interest.}

\item{tolerance}{The \emph{m/z} tolerance for the fragment ion search.
Default is \code{1E-05}, i.e. +/- 10ppm.}
}
\value{
If the respective fragment is only found in one spectrum, the output
    is an object of class \code{\linkS4class{MS2spectrum}}; if it is found in
    more than one spectrum, the output is a list of
    \code{\linkS4class{MS2spectrum}} objects.
}
\description{
\code{findFragment} is used to find spectra that contain a specific fragment
ion. Its sister function is \code{\link{findNL}}, which finds specific
neutral losses. Both functions work analogous to \code{\link{getSpectrum}}.
}
\examples{
load(file = system.file("extdata",
    "annotatedSpeclist.RData",
    package = "CluMSIDdata"))
putativeAQs <- findFragment(annotatedSpeclist, 159.068)

}
