% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes_methods.R
\docType{class}
\name{MS2spectrum-class}
\alias{MS2spectrum-class}
\alias{show,MS2spectrum-method}
\alias{precursorMz,MS2spectrum-method}
\alias{rtime,MS2spectrum-method}
\alias{intensity,MS2spectrum-method}
\alias{mz,MS2spectrum-method}
\alias{peaksCount,MS2spectrum,ANY-method}
\title{A custom S4 class for MS2 spectra, neutral loss patterns and
respective metainformation}
\usage{
\S4method{show}{MS2spectrum}(object)

\S4method{precursorMz}{MS2spectrum}(object)

\S4method{rtime}{MS2spectrum}(object)

\S4method{intensity}{MS2spectrum}(object)

\S4method{mz}{MS2spectrum}(object)

\S4method{peaksCount}{MS2spectrum,ANY}(object)
}
\arguments{
\item{object}{An object of class \code{\linkS4class{MS2spectrum}}}
}
\value{
Prints information from the object slots with exception of
    'spectrum' and 'neutral_losses' where only a summary is given.
}
\description{
A custom S4 class for MS2 spectra, neutral loss patterns and
respective metainformation
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: A show generic for \code{MS2spectra}.

\item \code{precursorMz}: Method for\code{MSnbase::precursorMz}
for \code{\linkS4class{MS2spectrum}} objects. Accesses \code{precursor}
slot and returns precursor \emph{m/z} as a numeric.

\item \code{rtime}: Method for\code{MSnbase::rtime}
for \code{\linkS4class{MS2spectrum}} objects. Accesses \code{rt}
slot and returns retention time as a numeric.

\item \code{intensity}: Method for\code{MSnbase::intensity}
for \code{\linkS4class{MS2spectrum}} objects. Accesses \code{spectrum}
slot and returns the intensity column as a numeric vector.

\item \code{mz}: Method for\code{MSnbase::mz}
for \code{\linkS4class{MS2spectrum}} objects. Accesses \code{spectrum}
slot and returns the \emph{m/z} column as a numeric vector.

\item \code{peaksCount}: Method for\code{MSnbase::mz}
for \code{\linkS4class{MS2spectrum}} objects. Accesses \code{spectrum}
slot and returns the number of peaks as a numeric.
}}

\section{Slots}{

\describe{
\item{\code{id}}{a character string similar to the ID used by XCMSonline
or the ID given in a predefined peak list}

\item{\code{annotation}}{a character string containing a user-defined
annotation, defaults to empty}

\item{\code{precursor}}{(median) \emph{m/z} of the spectrum's precursor ion}

\item{\code{rt}}{(median) retention time of the spectrum's precursor ion}

\item{\code{polarity}}{the ionisation polarity,
\code{"positive"} or \code{"negative"}}

\item{\code{spectrum}}{the actual MS2 spectrum as two-column matrix
(column 1 is (median) \emph{m/z}, column 2 is (median) intensity of the
product ions)}

\item{\code{neutral_losses}}{a neutral loss pattern generated by subtracting the
product ion mass-to-charge ratios from the precursor \emph{m/z} in a
matrix format analogous to the \code{spectrum} slot}
}}

