% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_clustering.R
\name{HCtbl}
\alias{HCtbl}
\title{Hierarchical clustering of spectral similarity data}
\usage{
HCtbl(distmat, h = 0.95)
}
\arguments{
\item{distmat}{A distance matrix as generated by
\code{\link{distanceMatrix}}.}

\item{h}{Height where the tree is to be cut, defaults to \code{0.95}.
See \code{\link[stats]{cutree}} for details.}
}
\value{
A \code{data.frame} with name and cluster ID for each
feature in \code{distmat}.
}
\description{
\code{HCtbl()} performs hierarchical clustering
of spectral similarity data using average linkage
as agglomeration criterion.
}
\examples{
load(file = system.file("extdata",
    "distmat.RData",
    package = "CluMSIDdata"))

my_HCtbl <- HCtbl(distmat[1:50,1:50], h = 0.8)

}
\seealso{
\code{\link{HCplot}}
}
