% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTest.R
\name{runTest}
\alias{runTest}
\alias{runTest,matrix-method}
\alias{runTest,DataFrame-method}
\alias{runTest,MultiAssayExperiment-method}
\title{Perform a Single Classification}
\usage{
\S4method{runTest}{matrix}(measurementsTrain, outcomeTrain, measurementsTest, outcomeTest, ...)

\S4method{runTest}{DataFrame}(
  measurementsTrain,
  outcomeTrain,
  measurementsTest,
  outcomeTest,
  crossValParams = CrossValParams(),
  modellingParams = ModellingParams(),
  characteristics = S4Vectors::DataFrame(),
  ...,
  verbose = 1,
  .iteration = NULL
)

\S4method{runTest}{MultiAssayExperiment}(measurementsTrain, measurementsTest, outcomeColumns, ...)
}
\arguments{
\item{measurementsTrain}{Either a \code{\link{matrix}}, \code{\link{DataFrame}}
or \code{\link{MultiAssayExperiment}} containing the training data. For a
\code{matrix} or \code{\link{DataFrame}}, the rows are samples, and the columns are features.}

\item{...}{Variables not used by the \code{matrix} nor the \code{MultiAssayExperiment} method which
are passed into and used by the \code{DataFrame} method or passed onwards to \code{\link{prepareData}}.}

\item{outcomeTrain}{Either a factor vector of classes, a \code{\link{Surv}} object, or
a character string, or vector of such strings, containing column name(s) of column(s)
containing either classes or time and event information about survival. If column names
of survival information, time must be in first column and event status in the second.}

\item{measurementsTest}{Same data type as \code{measurementsTrain}, but only the test
samples.}

\item{outcomeTest}{Same data type as \code{outcomeTrain}, but for only the test
samples.}

\item{crossValParams}{An object of class \code{\link{CrossValParams}},
specifying the kind of cross-validation to be done, if nested
cross-validation is used to tune any parameters.}

\item{modellingParams}{An object of class \code{\link{ModellingParams}},
specifying the class rebalancing, transformation (if any), feature selection
(if any), training and prediction to be done on the data set.}

\item{characteristics}{A \code{\link{DataFrame}} describing the
characteristics of the classification used. First column must be named
\code{"charateristic"} and second column must be named \code{"value"}.
Useful for automated plot annotation by plotting functions within this
package. Transformation, selection and prediction functions provided by
this package will cause the characteristics to be automatically determined
and this can be left blank.}

\item{verbose}{Default: 1. A number between 0 and 3 for the amount of
progress messages to give.  A higher number will produce more messages as
more lower-level functions print messages.}

\item{.iteration}{Not to be set by a user. This value is used to keep track
of the cross-validation iteration, if called by \code{\link{runTests}}.}

\item{outcomeColumns}{If \code{measurementsTrain} is a \code{MultiAssayExperiment}, the
names of the column (class) or columns (survival) in the table extracted by \code{colData(data)}
that contain(s) the samples' outcome to use for prediction.}
}
\value{
If called directly by the user rather than being used internally by
\code{\link{runTests}}, a \code{\link{ClassifyResult}} object. Otherwise a
list of different aspects of the result which is passed back to \code{\link{runTests}}.
}
\description{
For a data set of features and samples, the classification process is run.
It consists of data transformation, feature selection, classifier training
and testing.
}
\details{
This function only performs one classification and prediction. See
\code{\link{runTests}} for a driver function that enables a number of
different cross-validation schemes to be applied and uses this function to
perform each iteration.
}
\examples{

  #if(require(sparsediscrim))
  #{
    data(asthma)
    CVparams <- CrossValParams(tuneMode = "Resubstitution")
    tuneList <- list(nFeatures = seq(5, 25, 5))
    attr(tuneList, "performanceType") <- "Balanced Error"
    selectParams <- SelectParams("limma", tuneParams = tuneList)
    modellingParams <- ModellingParams(selectParams = selectParams)
    trainIndices <- seq(1, nrow(measurements), 2)
    testIndices <- seq(2, nrow(measurements), 2)
    
    runTest(measurements[trainIndices, ], classes[trainIndices],
            measurements[testIndices, ], classes[testIndices],
            crossValParams = CVparams, modellingParams = modellingParams)
  #}

}
\author{
Dario Strbenac
}
