% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precisionPathways.R
\name{precisionPathwaysTrain}
\alias{precisionPathwaysTrain}
\alias{precisionPathwaysPredict}
\alias{precisionPathwaysTrain,MultiAssayExperimentOrList-method}
\alias{precisionPathwaysPredict,PrecisionPathways,MultiAssayExperimentOrList-method}
\title{Precision Pathways for Sample Prediction Based on Prediction Confidence.}
\usage{
\S4method{precisionPathwaysTrain}{MultiAssayExperimentOrList}(
  measurements,
  class,
  useFeatures = NULL,
  maxMissingProp = 0,
  topNvariance = NULL,
  fixedAssays = "clinical",
  confidenceCutoff = 0.8,
  minAssaySamples = 10,
  mode = c("stability", "combinatorial"),
  nFeatures = 20,
  selectionMethod = setNames(c("none", rep("t-test", length(measurements))),
    c("clinical", names(measurements))),
  classifier = setNames(c("elasticNetGLM", rep("randomForest", length(measurements))),
    c("clinical", names(measurements))),
  nFolds = 5,
  nRepeats = 20,
  nCores = 1
)

\S4method{precisionPathwaysPredict}{PrecisionPathways,MultiAssayExperimentOrList}(pathways, measurements, class)
}
\arguments{
\item{measurements}{Either a \code{\link{MultiAssayExperiment}} or a list of the basic tabular objects containing the data.}

\item{class}{If a \code{\link{MultiAssayExperiment}}, a column name in \code{colData(measurements)} with the classes. If \code{measurements} is a \code{list} of tabular data, may also be
a vector of classes.}

\item{useFeatures}{Default: \code{NULL} (i.e. use all provided features). A named list of features to use. Otherwise, the input data is a single table and this can just be a vector of feature names.
For any assays not in the named list, all of their features are used. \code{"clinical"} is also a valid assay name and refers to the clinical data table.
This allows for the avoidance of variables such spike-in RNAs, sample IDs, sample acquisition dates, etc. which are not relevant for outcome prediction.}

\item{maxMissingProp}{Default: 0.0. A proportion less than 1 which is the maximum
tolerated proportion of missingness for a feature to be retained for modelling.}

\item{topNvariance}{Default: NULL. An integer number of most variable features per assay to subset to.
Assays with less features won't be reduced in size.}

\item{fixedAssays}{A character vector of assay names specifying any assays which must be at the
beginning of the pathway.}

\item{confidenceCutoff}{The minimum confidence of predictions for a sample to be predicted by a particular assay. If a sample
was predicted to belong to a particular class a proportion \eqn{p} times, then the confidence is \eqn{2 \times |p - 0.5|}.}

\item{minAssaySamples}{An integer specifying the minimum number of samples a tier may have. If a subsequent tier
would have less than this number of samples, the samples are incorporated into the current tier.}

\item{mode}{Default: \code{"stability"}. Either \code{"stability"} or \code{"combinatorial"}. If \code{"stability"}, then pathways grow by
passing samples with confidence below \code{confidenceCutoff} to the next assay, until the assays are exhausted or the samples are.
If \code{"combinatorial"}, then all possible combinations of assays respecting \code{fixedAssays}, as well as each assay individually
are considered.}

\item{nFeatures}{Default: 20. The number of features to consider during feature selection, if feature selection is done.}

\item{selectionMethod}{A named character vector of feature selection methods to use for the assays, one for each. The names must correspond to names of \code{measurements}.}

\item{classifier}{A named character vector of modelling methods to use for the assays, one for each. The names must correspond to names of \code{measurements}.}

\item{nFolds}{A numeric specifying the number of folds to use for cross-validation.}

\item{nRepeats}{A numeric specifying the the number of repeats or permutations to use for cross-validation.}

\item{nCores}{A numeric specifying the number of cores used if the user wants to use parallelisation.}

\item{pathways}{A set of pathways created by \code{precisionPathwaysTrain} which is an object of class \code{PrecisionPathways} to be used for predicting on a new data set.}
}
\value{
An object of class \code{PrecisionPathways} which is basically a named list that other plotting and
tabulating functions can use.
}
\description{
Precision pathways allows the evaluation of various permutations of multiomics or multiview data.
Samples are predicted by a particular assay if they were consistently predicted as a particular class
during cross-validation. Otherwise, they are passed onto subsequent assays/tiers for prediction. Balanced accuracy
is used to evaluate overall prediction performance and sample-specific accuracy for individual-level evaluation.
}
\examples{
# To be determined.
}
