% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{wrapper_Signac_FeatureMatrix}
\alias{wrapper_Signac_FeatureMatrix}
\title{Wrapper around 'FeatureMatrix' function from Signac Package}
\usage{
wrapper_Signac_FeatureMatrix(
  files_dir_list,
  which,
  ref = "hg38",
  process_n = 2000,
  set_future_plan = TRUE,
  verbose = TRUE,
  progress = NULL
)
}
\arguments{
\item{files_dir_list}{A named character vector of directories containing
the files. The names correspond to sample names.}

\item{which}{A GenomicRanges containing the features to count on.}

\item{ref}{Reference genome to use (hg38).Chromosomes that are not present in
the canonical chromosomes of the given reference genome will be excluded from
the matrix.}

\item{process_n}{Number of regions to load into memory at a time, per thread.
Processing more regions at once can be faster but uses more memory. (2000)}

\item{set_future_plan}{Set 'multisession' plan within the function (TRUE).
If TRUE, the previous plan (e.g. future::plan()) will be set back on exit.}

\item{verbose}{Verbose (TRUE).}

\item{progress}{Progress object for Shiny.}
}
\value{
A sparse matrix of features x cells
}
\description{
Wrapper around 'FeatureMatrix' function from Signac Package
}
\details{
Signac & future are not required packages for ChromSCape as they are
required only for the fragment matrix calculations. To use this function,
install Signac package first (future will be installed as a dependency).
For the simplicity of the application & optimization, the function
by defaults sets future::plan("multisession") with workers =
future::availableCores(omit = 1) in order to allow parallel processing
with Signac. On exit the plan is re-set to the previously set future plan.
Note that future multisession may have trouble running when VPN is on. To
run in parallel, first deactivate your VPN if you encounter long runtimes.
}
\examples{
\dontrun{
gr_bins = define_feature("hg38", bin_width = 50000)
wrapper_Signac_FeatureMatrix("/path/to/dir_containing_fragment_files",
 gr_bins, ref = "hg38")
}
}
\references{
Stuart el al.,  Multimodal single-cell chromatin analysis with
Signac bioRxiv \url{https://doi.org/10.1101/2020.11.09.373613}
}
