% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{raw_counts_to_sparse_matrix}
\alias{raw_counts_to_sparse_matrix}
\title{Create a sparse count matrix from various format of input data.}
\usage{
raw_counts_to_sparse_matrix(
  files_dir_list,
  file_type = c("scBED", "scBAM", "FragmentFile"),
  use_Signac = TRUE,
  peak_file = NULL,
  n_bins = NULL,
  bin_width = NULL,
  genebody = NULL,
  extendPromoter = 2500,
  verbose = TRUE,
  ref = c("hg38", "mm10", "ce11")[1],
  progress = NULL,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{files_dir_list}{A named character vector of directories containing
the files. The names correspond to sample names.}

\item{file_type}{Input file(s) type(s) ('scBED','scBAM','FragmentFile')}

\item{use_Signac}{Use Signac wrapper function 'FeatureMatrix' if the Signac
package is installed (TRUE).}

\item{peak_file}{A file containing genomic location of peaks (NULL)}

\item{n_bins}{The number of bins to tile the genome (NULL)}

\item{bin_width}{The size of bins to tile the genome (NULL)}

\item{genebody}{Count on genes (body + promoter) ? (NULL)}

\item{extendPromoter}{If counting on genes, number of base pairs to extend up or
downstream of TSS (2500).}

\item{verbose}{Verbose (TRUE)}

\item{ref}{reference genome to use (hg38)}

\item{progress}{Progress object for Shiny}

\item{BPPARAM}{BPPARAM object for multiprocessing. See
\link[BiocParallel]{bpparam} for more informations. Will take the default
BPPARAM set in your R session.}
}
\value{
A sparse matrix of features x cells
}
\description{
This function takes three different type of single-cell input: - Single cell
BAM files (sorted) - Single cell BED files (gzipped) - A combination of an
index file, a peak file and cell barcode file (The index file is composed of
three column: index i, index j and value x for the non zeroes entries in the
sparse matrix.)
}
\details{
This functions re-counts signal on either fixed genomic bins, a set of
user-defined peaks or around the TSS of genes.
}
\references{
Stuart el al.,  Multimodal single-cell chromatin analysis with
Signac bioRxiv \url{https://doi.org/10.1101/2020.11.09.373613}
}
