% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analysis_gene_set_enrichment.R
\name{enrich_TF_ChEA3_scExp}
\alias{enrich_TF_ChEA3_scExp}
\title{Find the TF that are enriched in the differential genes using ChEA3 database}
\usage{
enrich_TF_ChEA3_scExp(
  scExp,
  qval.th = 0.01,
  logFC.th = 1,
  min.percent = 0.01,
  peak_distance = 1000,
  use_peaks = FALSE,
  progress = NULL,
  verbose = TRUE
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object containing list of differential
features.}

\item{qval.th}{Adjusted p-value threshold to define differential features.
(0.01)}

\item{logFC.th}{Fold change threshold to define differential features. (1)}

\item{min.percent}{Minimum fraction of cells having the feature active to
consider it as significantly differential. (0.01)}

\item{peak_distance}{Maximum distanceToTSS of feature to gene TSS to consider
associated, in bp. (1000)}

\item{use_peaks}{Use peak calling method (must be calculated beforehand).
(FALSE)}

\item{progress}{A shiny Progress instance to display progress bar.}

\item{verbose}{A logical to print message or not. (TRUE)}
}
\value{
Returns a SingleCellExperiment object containing list of enriched
Gene Sets for each cluster, either in depleted features, enriched features
or simply differential features (both).
}
\description{
Find the TF that are enriched in the differential genes using ChEA3 database
}
\examples{
data("scExp")

scExp = enrich_TF_ChEA3_scExp(
 scExp,
 qval.th = 0.01,
 logFC.th = 1,
 min.percent = 0.01)


}
