% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_analysis.R
\name{create_project_folder}
\alias{create_project_folder}
\title{Create ChromSCape project folder}
\usage{
create_project_folder(
  output_directory,
  analysis_name = "Analysis_1",
  ref_genome = c("hg38", "mm10", "ce11")[1]
)
}
\arguments{
\item{output_directory}{Path towards the directory to create the
'ChromSCape_Analyses' folder and the analysis subfolder. If this path
already contains the 'ChromSCape_Analyses' folder, will only create the
analysis subfolder.}

\item{analysis_name}{Name of the analysis. Must only contain alphanumerical
characters or '_'.}

\item{ref_genome}{Reference genome, either 'hg38' or 'mm10'.}
}
\value{
Creates the project folder and returns the root of the project.
}
\description{
Creates a project folder that will be recognizable by ChromSCape Shiny
application.
}
\examples{
dir = tempdir()  
create_project_folder(output_directory = dir,
 analysis_name = "Analysis_1")
list.dirs(file.path(dir))
}
