% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagMatrix.R
\name{makeBioRegionFromGranges}
\alias{makeBioRegionFromGranges}
\title{makeBioRegionFromGranges}
\usage{
makeBioRegionFromGranges(gr, by, type, upstream = 1000, downstream = 1000)
}
\arguments{
\item{gr}{a grange object contain region of interest}

\item{by}{specify be users, e.g. gene, insulator, enhancer}

\item{type}{one of "start_site", "end_site", "body"}

\item{upstream}{upstream from start site or end site, can be NULL if the type == 'body'}

\item{downstream}{downstream from start site or end site, can be NULL if the type == 'body'}
}
\value{
GRanges object
}
\description{
make windows from granges object
}
\details{
\code{makeBioRegionFromGranges()} function can make bioregion from granges object.

The differences between \code{makeBioRegionFromGranges()} and \code{getBioRegion()} is that
\code{getBioRegion()} get the region object from \code{txdb} object but
\code{makeBioRegionFromGranges()} get the region from the granges object provided by users.
For example, \code{txdb} object do not contain insulator or enhancer regions. Users can
provide these regions through self-made granges object

There are three kinds of regions, \code{start_site}, \code{end_site} and \code{body}. 

We take enhancer region to explain the differences of these three regions.
enhancer: chr1 1000 1400. 

\code{body} region refers to the 1000-1400bp.

\code{start_site} region with \code{upstream = 100, downstream = 100} refers to 900-1100bp. 

\code{end_site} region with \code{upstream = 100, downstream = 100} refers to 1300-1500bp.

In \code{makeBioRegionFromGranges()}, \code{upstream} and \code{downstream} can be
\code{NULL} if the \code{type == 'body'}. \code{by} should be specified by users and 
can not be omitted. \code{by} parameter will be used to made labels. \code{type} should also
be specified.

\url{https://github.com/YuLab-SMU/ChIPseeker/issues/189}
}
