% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ExoData-class}
\alias{ExoData-class}
\alias{ExoData}
\alias{ExoData-class}
\title{ExoData object and constructors}
\usage{
ExoData(file = NULL, reads = NULL, height = 1,
  mc.cores = getOption("mc.cores", 2L), save.reads = FALSE,
  nregions = 1000, ntimes = 100, verbose = TRUE)
}
\arguments{
\item{file}{a character value with location of the bam file with the aligned
reads.}

\item{reads}{a \code{GAlignments} object with the aligned reads of a ChIP-exo
sample. It is meant to be used instead of \code{file}.}

\item{height}{a numeric value indicating the value used to slice the coverage
of the experiment into a set of regions.}

\item{mc.cores}{a numeric value with the number of cores to use,
i.e. at most how many child processes will be run simultaneously.}

\item{save.reads}{a logical value to indicate if the reads are stored in the
\code{ExoData} object. The default value is \code{FALSE}.}

\item{nregions}{a numeric value indicating the number of regions sampled to 
estimate the quality parameter distributions. The default value is 1e3.}

\item{ntimes}{a numeric value indicating the number of times that regions are 
sampled to estimate the quality parameter distributions. The default value
is 1e2.}

\item{verbose}{a logical value indicating if the user want to receive progress
details. The default value is FALSE.}
}
\value{
It returns an \code{ExoData} object with the regions obtained after
partitioning the genome and the summary statistics for each region. If the
\code{save.reads} parameter is \code{TRUE} then it contains a \code{GRanges}
object with the reads of the ChIP-exo experiment.
}
\description{
\code{ExoData} is a subclass of \code{GenomicRanges}, used to asses the 
quality of ChIP-exo/nexus sample.
}
\examples{

files <- list.files(system.file("extdata",package = "ChIPexoQualExample"),
    full.names = TRUE)
ExoData(files[5],mc.cores = 2L)


}
