% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{userLandmarks<-}
\alias{userLandmarks<-}
\alias{userLandmarks<-,SingleCellExperiment-method}
\title{SET user-defined landmarks}
\usage{
userLandmarks(object) <- value
}
\arguments{
\item{object}{A \code{SingleCellExperiment} object}

\item{value}{A character vector with sample names}
}
\value{
An updated \code{SingleCellExperiment} object
}
\description{
Set user-defined landmarks to a \code{SingleCellExperiment} object.
}
\details{
Landmarks can be defined on the trajectory and can be necessary to
extract individual trails from a trajectory.
\cr \cr
\emph{Diagnostic messages}
\cr \cr
An error is thrown if the trajectory has not been reconstructed yet.
}
\examples{
# Example data
data(exSCE)

# Set landmarks
userLandmarks(exSCE) <- colnames(exSCE)[5:7]
}
\seealso{
\code{SingleCellExperiment} \code{fitTrajectory}
}
\author{
Daniel C. Ellwanger
}
