% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherMetrics.R
\name{isi}
\alias{isi}
\title{isi}
\usage{
isi(
  sce,
  group,
  k,
  dim_red = "PCA",
  assay_name = "logcounts",
  n_dim = 10,
  weight = TRUE,
  res_name = NULL
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} object, with the integrated data.}

\item{group}{Character. Name of group/batch variable.
Needs to be one of \code{names(colData(sce))}.}

\item{k}{Numeric. Number of k-nearest neighbours (knn) to use.}

\item{dim_red}{Character. Name of embeddings to use as subspace for distance
distributions. Default is "PCA".}

\item{assay_name}{Character. Name of the assay to use for PCA.
Only relevant if no existing 'dim_red' is provided.}

\item{n_dim}{Numeric. Number of dimensions to include to define the subspace.}

\item{weight}{Boolean. If TRUE, batch probabilities to calculate the isi
score are weighted by the mean distance of their cells towards the cell
of interest. Relevant for metrics: 'isi'.}

\item{res_name}{Character. Appendix of the result score's name
(e.g. method used to combine batches).}
}
\value{
A \code{SingleCellExperiment} with the entropy score within colData.
}
\description{
isi
}
\details{
The isi function calculates the inverse Simpson index of the group
variable within each cell's k-nearest neighbourhood.
The Simpson index describes the probability that two entities are taken at
random from the dataset and its inverse represent the effective number of
batches in a neighbourhood. The inverse Simpson index has been proposed as a
diversity score for batch mixing in single cell RNAseq by Korunsky et al.
They provide a distance-based neighbourhood weightening in their Lisi package.
Here, we provide a simplified way of weightening probabilitities, if the
\code{weight} argument is enabled.
}
\examples{
library(SingleCellExperiment)
sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))
sce <- sim_list[[1]][, c(1:15, 400:420, 16:30)]

sce <- isi(sce, "batch", k = 20)
}
\references{
Korsunsky I Fan J Slowikowski K Zhang F Wei K et. al. (2018).
Fast, sensitive, and accurate integration of single cell data with Harmony.
bioRxiv (preprint)
}
