% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsHelper.R
\name{.cmsCell}
\alias{.cmsCell}
\title{.cmsCell}
\usage{
.cmsCell(
  cell,
  group,
  knn,
  k_min = NA,
  batch_min = NULL,
  cell_min = 4,
  unbalanced = FALSE,
  sce
)
}
\arguments{
\item{cell}{Character. Name of the cell to calculate cms for.
Needs to be one of \code{rownames(knn)}.}

\item{group}{Character. Name of group/batch variable.
Needs to be one of \code{names(knn)}.}

\item{knn}{List with three elements. First "index" with indices of knn cells.
Second "distance" with distances to knn cells. Third a slot named by
\code{group} variable with group level of knn cells.}

\item{k_min}{Numeric. Minimum number of knn to include.
Default is NA (see Details).}

\item{batch_min}{Numeric. Minimum number of cells per batch to include in to
the AD test. If set neighbours will be included until batch_min cells from
each batch are present.}

\item{cell_min}{Numeric. Minimum number of cells from each group to be
included into the AD test. Should be > 4 to make 'ad.test' working.}

\item{unbalanced}{Boolean. If True neighbourhoods with only one batch present
will be set to NA. This way they are not included into any summaries or
smoothening.}

\item{sce}{A \code{SingleCellExperiment} object with the combined data.}
}
\value{
A p.value as resulting from the ad.test.
}
\description{
Function to calculate a cellspecific mixing score (cms) of groups/batches.
}
\details{
The cms function tests the hypothesis, that group-specific distance
distributions of knn cells have the same underlying unspecified distribution.
It performs Anderson-Darling tests as implemented in the
\code{kSamples package}.
In default the function uses all distances and group label defined in knn.
If \code{k_min} is specified, the first local minimum of the overall distance
distribution with at least kmin cells is used. This can be used to adapt to
the local structure of the datatset e.g. prevent cells from a distinct
different cluster to be included.
}
\seealso{
\code{\link{ad.test}}, \code{\link{cms}}, \code{\link{.smoothCms}}

Other helper functions: 
\code{\link{.defineSubspace}()},
\code{\link{.filterKnn}()},
\code{\link{.filterLocMin}()},
\code{\link{.ldfKnn}()},
\code{\link{.smoothCms}()}
}
\concept{helper functions}
