% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{collapse_pipeline}
\alias{collapse_pipeline}
\alias{pipeline_collapse}
\title{Collapse benchmark_tbl into a two column summary}
\usage{
collapse_pipeline(
  x,
  sep = arrow_sep("right"),
  drop.steps = TRUE,
  data.name = TRUE
)

pipeline_collapse(
  x,
  sep = arrow_sep("right"),
  drop.steps = TRUE,
  data.name = TRUE
)
}
\arguments{
\item{x}{the benchmark_tbl to collapse}

\item{sep}{the separator to use for concatenating the pipeline steps}

\item{drop.steps}{if the data name and methods steps should be dropped from
the output. TRUE by default.}

\item{data.name}{if the dataset name should be included in the pipeline
string. Useful if only a single dataset is used.}
}
\value{
benchmark_tbl with pipeline and result columns (and all other columns
  if drop.steps is FALSE)
}
\description{
Collapse benchmark_tbl into two columns: "pipeline" and "result". The
"pipeline" column will be the concatenated values from the data and methods
columns while the "result" column remains unchanged from the benchmark_tbl.
This is useful for having a string summary of the pipeline for annotating.
}
\examples{
# list of data
datasets <- list(
    set1 = rnorm(500, mean = 2, sd = 1),
    set2 = rnorm(500, mean = 1, sd = 2)
)

# list of functions
add_noise <- list(
    none = identity,
    add_bias = function(x) { x + 1 }
)

res <- apply_methods(datasets, add_noise)
collapse_pipeline(res)
}
\seealso{
\code{\link{as_pipeline_list}}
}
