% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histPlot.R
\name{histPlot}
\alias{histPlot}
\title{Histogram of connectivity distribution}
\usage{
histPlot(mat)
}
\arguments{
\item{mat}{Adjacency matrix resulting from PCIT analysis in which
has some zero values.}
}
\value{
Returns the histogram of connectivity distribution.
}
\description{
Generate the histogram for adjacency matrix to
show the clustering coefficient distribution.
}
\examples{
# loading a simulated normalized data
data(simNorm)

# getting the PCIT results for first 30 genes
results <- PCIT(simNorm[1:30, ])

# plotting the histogram for PCIT significance results
histPlot(results$adj_sig)



}
