% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateSignificanceUsingCubicAlgorithm.r
\name{CalculateSignificanceUsingCubicAlgorithm}
\alias{CalculateSignificanceUsingCubicAlgorithm}
\title{calculate significance using the cubic algorithm}
\usage{
CalculateSignificanceUsingCubicAlgorithm(hypothesisScore, predictionListStats,
  experimentalDataStats, epsilon)
}
\arguments{
\item{hypothesisScore}{the score whose p-value we want to find.}

\item{predictionListStats}{numbers of predicted up-regulated, predicted down-regulated and ambiguous predictions.}

\item{experimentalDataStats}{numbers of up-regulated, down-regulated and not significantly changed transcripts in the experimental data.}

\item{epsilon}{an epsilon threshold that is used when calculating the p-value 
using the cubic algorithm. Defaults to 1e-5.}
}
\value{
p-value
}
\description{
Calculates the p-value of a score given the hypothesis score and the distribution table (calculated using the cubic algorithm)
}
\examples{
CalculateSignificance(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=TRUE)
CalculateSignificanceUsingQuarticAlgorithm(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=FALSE)
CalculateSignificance(5, c(7,4,19), c(6,6,18), 1e-5)
CalculateSignificance(5, c(7,4,19), c(6,6,18), epsilon=1e-5, useCubicAlgorithm=TRUE)
CalculateSignificanceUsingCubicAlgorithm(5, c(7,4,19), c(6,6,18), 1e-5)
}
\references{
L Chindelevitch et al.
Assessing statistical significance in causal graphs.
BMC Bioinformatics, 13(35), 2012.
}
\concept{
CausalR
}

