% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterAdj.R
\name{mutFilterAdj}
\alias{mutFilterAdj}
\title{mutFilterAdj}
\usage{
mutFilterAdj(maf, maxIndelLen = 50, minInterval = 10)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{maxIndelLen}{Maximum length of indel accepted to be included.
Default: 50}

\item{minInterval}{Minimum length of interval between an SNV and an indel
accepted to be included. Default: 10}
}
\value{
An MAF data frame after filtration for adjacent variants.
}
\description{
Filter SNVs with adjacent indels
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterAdj(maf)
}
