% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topn_best.R
\name{topn_best}
\alias{topn_best}
\title{Top 'N' Best Meta-Features}
\usage{
topn_best(topn_list)
}
\arguments{
\item{topn_list}{A nested list of objects that are returned 
from \code{candidate_search} using the following parameters:
\code{FS = sim_FS}, \code{input_score = sim_Scores}, 
\code{top_N = 7}, \code{method = "ks_pval"}, \code{alternative = "less"}, 
\code{search_method = "both"}, \code{max_size = 10}, and 
\code{best_score_only = FALSE}.}
}
\value{
A list of objects containing the best meta-feature matrix, its 
corresponding best score, its observed input scores, rank of best 
meta-features based on their scores, its marginal and cumulative best scores.
}
\description{
Take the resulting list of meta-features returned from 
\code{candidate_search} over top N feature searches and 
fetch the meta-feature with the best score.
}
\examples{

# Load pre-computed Top-N list generated for sim_FS dataset
data(topn_list)

# Get the best meta-features list
topn_best_meta <- topn_best(topn_list = topn_list)

}
