% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CCLE_data}
\alias{CCLE_data}
\title{Genes expression data in CCLE}
\format{
A \code{SummarizedExperiment} object with 24473 rows and 1229 columns
\itemize{
\item Rows correspond to genes (ensembl_gene_id)
\item Columns correspond to CCLE cell lines
\item Expression data from the assay are TPM values
\item Cell lines metadata are stored in colData
}
}
\source{
TPM values downloaded using depmap bioconductor package (see
\code{scripts/make_CCLE_data.R} for details).
}
\description{
Gene expression data in cancer cell lines from CCLE
}
\details{
The rowData contains
\itemize{
\item A column \code{percent_of_positive_CCLE_cell_lines} that gives the
percentage of CCLE cell lines (all cell lines combined)
expressing the gene (TPM >= 1).
\item A column \code{percent_of_negative_CCLE_cell_lines} that gives the
percent of CCLE cell lines (all cell lines combined) in which
genes are repressed (TPM < 0.5)
\item A column \code{max_TPM_in_CCLE} that gives the maximal expression (in
TPM) found in all cell lines.
\item A column \code{CCLE_category} gives the category ("activated",
"not_activated", "leaky") assigned to each gene.  "activated"
category corresponds to genes expressed (TPM >= 1) in at
least 1\% of cell lines, repressed (TPM <= 0.5) in at least 20\% of
cell lines with a maximal expression higher than 5 TPM.
"not_activated" category corresponds to genes
repressed (TPM <= 0.5) in at least 20\% of cell lines but
expressed (TPM >= 1) less than 1\%.  "leaky" category
corresponds to genes repressed (TPM <= 0.5) in less than 20\% of
cell lines. "lowly_expressed" corresponds to genes repressed (TPM <= 0.5)
in at least 20\%, expressed (TPM >= 1) in more than 1 \% of cell lines, with
a maximum expression lower than 5 TPM.
}
}
