% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ctd.R
\name{load_ctd_gene}
\alias{load_ctd_gene}
\title{Function to load the \code{.tsv.gz} file for genes}
\usage{
load_ctd_gene(verbose = FALSE)
}
\arguments{
\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} messages and
warnings are raised.}
}
\value{
A \code{data.frame} with the content of the file "CTD_genes.tsv.gz"
}
\description{
This function works in pair with \code{\link{download_ctd_genes}}. This
function loads into the R session the downloaded \code{"CTD_genes.tsv.gz"}
file.
}
\details{
The field included in the file (\code{CTD_genes.tsv.gz}) are:
\enumerate{
 \item GeneSymbol
 \item GeneName
 \item GeneID (NCBI Gene identifier)
 \item AltGeneIDs (alternative NCBI Gene identifiers; '|'-delimited list)
 \item Synonyms ('|'-delimited list)
 \item BioGRIDIDs ('|'-delimited list)
 \item PharmGKBIDs ('|'-delimited list)
 \item UniprotIDs ('|'-delimited list)
}
}
\examples{
if(download_ctd_genes()){
fdl <- load_ctd_gene()
dim( fdl )
}
}
