% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ctd.R
\name{load_ctd_chem}
\alias{load_ctd_chem}
\title{Function to load the \code{.tsv.gz} file for chemicals}
\usage{
load_ctd_chem(verbose = FALSE)
}
\arguments{
\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} messages and
warnings are raised.}
}
\value{
A \code{data.frame} with the content of the file "CTD_genes.tsv.gz"
}
\description{
Function to load the \code{.tsv.gz} file for chemicals
}
\details{
The field included in the file (\code{CTD_chemicals.tsv.gz}) are:
\enumerate{
 \item ChemicalName
 \item ChemicalID (MeSH identifier)
 \item CasRN (CAS Registry Number, if available)
 \item Definition
 \item ParentIDs (identifiers of the parent terms; '|'-delimited list),
 \item TreeNumbers (identifiers of the chemical's nodes; '|'-delimited list),
 \item ParentTreeNumbers (identifiers of the parent nodes; '|'-delimited list),
 \item Synonyms ('|'-delimited list)
 \item DrugBankIDs ('|'-delimited list)
 }
}
\examples{
if(download_ctd_chem()){
fdl <- load_ctd_chem()
dim( fdl )
}
}
