% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_test_f.R
\name{tr_test_f}
\alias{tr_test_f}
\title{Train-Test Split Function}
\usage{
tr_test_f(data, fraction)
}
\arguments{
\item{data}{A data frame containing the dataset to be split.}

\item{fraction}{A numeric value between 0 and 1 indicating the proportion
of data to include in the training set.}
}
\value{
A list containing two data frames:
\describe{
\item{train_data}{A data frame containing the training set.}
\item{test_data}{A data frame containing the testing set.}
}
}
\description{
This function splits a given dataset into training and testing sets based
on a specified fraction.
}
\details{
The function checks whether the input \code{data} is valid and whether the
\code{fraction} is a number between 0 and 1.
It then performs a random split of the dataset into training and testing
sets.
}
\examples{
# Example dataset
data <- data.frame(x = rnorm(100), y = rnorm(100))
fraction <- 0.7
result <- tr_test_f(data, fraction)
head(result$train_data)
head(result$test_data)

}
