% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_curve_plots_f.R
\name{surv_curve_plots_f}
\alias{surv_curve_plots_f}
\title{Generate Survival Curve Plots}
\arguments{
\item{Surv_curve_data}{A data frame containing survival curve data. The
data frame must include a column named \code{time_point} representing time and
other columns corresponding to patient survival probabilities.}

\item{selected_sample}{A character string specifying the patient ID to be
highlighted in the plot.}

\item{font_size}{Numeric. Font size for axis labels, titles, and legends.
Must be supplied by the user.}

\item{line_size}{Numeric. Line thickness for plotted curves. Must be supplied
by the user.}

\item{all_line_col}{Character. Color used for all non-highlighted patients
(e.g., \code{"black"}). Must be supplied by the user.}

\item{highlight_col}{Character. Color used to highlight the selected patient
(e.g., \code{"red"}). Must be supplied by the user.}
}
\value{
A list containing two ggplot2 objects:
\item{all_patients_plot}{A ggplot object displaying survival curves for
all patients.}
\item{highlighted_patient_plot}{A ggplot object displaying survival
curves for all patients with the selected patient highlighted.}
}
\description{
This function creates survival curve plots for all patients and highlights a
specific patient based on the selected sample.
}
\details{
\itemize{
\item The input data (\code{Surv_curve_data}) must be structured such that the
first column (\code{time_point}) represents time points, and each subsequent
column represents the survival probabilities for a specific patient.
\item If the \code{selected_sample} is not present in the column names
of \code{Surv_curve_data}, a message will indicate that the sample is missing.
\item The function uses the \code{ggplot2} package for generating survival
curve plots.
}
}
\examples{
# Example survival curve data
Surv_curve_data <- data.frame(
  time_point = c(0, 1, 2, 3, 4),
  Patient1 = c(1, 0.9, 0.8, 0.7, 0.6),
  Patient2 = c(1, 0.85, 0.75, 0.65, 0.55)
)

# Generate plots with Patient1 highlighted
plots <- surv_curve_plots_f(
  Surv_curve_data,
  selected_sample = "Patient1",
  font_size = 12,
  line_size = 0.5,
  all_line_col = "black",
  highlight_col = "red"
)

# View the plots
print(plots$all_patients_plot)
print(plots$highlighted_patient_plot)

}
