% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MultiThreading}
\alias{MultiThreading}
\alias{handleMultiCore}
\alias{canUseTorch}
\title{Handling Multi-Core and GPU environments}
\usage{
handleMultiCore(cores)

canUseTorch(optimizeForSpeed, deviceStr)
}
\arguments{
\item{cores}{the number of cores asked for}

\item{optimizeForSpeed}{A Boolean to indicate whether to try to use the
faster torch library}

\item{deviceStr}{The name of the device to be used by torch}
}
\value{
\code{handleMultiCore()} returns the maximum sensible number of cores to
use

\code{canUseTorch()} returns a list with 2 elements:
\itemize{
\item \code{"useTorch"}: a Boolean indicating whether the torch library can be used
\item \code{"deviceStr"}: the updated name of the device to be used: if no \code{cuda} GPU
is available it will fallback to CPU calculations
}
}
\description{
Check whether session supports multi-core and/or GPU evaluation
and utilities about their activation
}
\details{
\code{handleMultiCore()} uses \code{\link[parallelly:supportsMulticore]{parallelly::supportsMulticore()}} and
\code{\link[parallelly:availableCores]{parallelly::availableCores()}} to actually check whether the session
supports multi-core evaluation. Provides an effective upper bound to the
number of cores.

\code{canUseTorch()} is an internal function to handle the torch library:
it returns whether \pkg{torch} is ready to be used. It obeys the opt-out
flag set via the \code{COTAN.UseTorch} option
}
\seealso{
the help page of \code{\link[parallelly:supportsMulticore]{parallelly::supportsMulticore()}} about the flags
influencing the multi-core support; e.g. the usage of \code{R} option
\code{parallelly.fork.enable}.

\code{\link[torch:install_torch]{torch::install_torch()}} and \code{\link[torch:torch_is_installed]{torch::torch_is_installed()}} for
installation. Note the \code{\link[torch:threads]{torch::torch_set_num_threads()}} has effect also on
the \pkg{Rfast} package methods
}
