% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_NBE.R
\name{cpoints}
\alias{cpoints}
\title{cpoints}
\usage{
cpoints(data, thresh, cmethod, sig.level, Q, path.type, seed)
}
\arguments{
\item{data}{List. A list of adjusted fluorescence signals in both channels. Typically,
the output of transformFluo().}

\item{thresh}{Integer. The minimum number of values for a cluster re-estimated by the
change-point analysis.}

\item{cmethod}{Character string. The change point method to be used. It can be one of "ECP",
(non-parametric) "manualECP" (non-parametric with user-defined numner of change-points) or
"PELT" (Pruned Exact Linear Time; parametric).}

\item{sig.level}{Float. The significance level below which we do not reject a change point.}

\item{Q}{Integer. The number of change-points to be kept if CPmethod = "manualECP".}

\item{path.type}{Character vector. A user-defined vector that characterizes the cell progression dynamics.
The first element can be either "circular" or "A2Z" or "other". If "circular" the path progression is
assummed to exhibit a circle-like behavior. If "A2Z" the path is assumed to have a well-defined start
and a well-defined end point (e.g. a linear progression). If "other" the progression is assumed to be
arbitrary without an obvious directionality.}

\item{seed}{Integer. An optional seed number for the Random Number Generator.}
}
\value{
A list with the adjusted fluorescence signals and their change-points
}
\description{
It performs the change-point analysis of the variance stabilized adjusted fluorescence signals.
}
\keyword{internal}
