##' Simulated COMPASSContainer
##'
##' This dataset contains simulated data for an intracellular cytokine
##' staining experiment. In this data set, we have paired samples from
##' five individuals, with each pair of samples being subjected to
##' either a 'Control' condition of a 'Treatment' condition.
##'
##' Please see \code{\link{COMPASSContainer}} for more information on the
##' components of this object.
##'
##' The dataset is exported as \code{CC}, which is a short alias
##' for \strong{C}\code{OMPASS}\strong{C}\code{ontainer}.
##'
##' @docType data
##' @name COMPASSContainer-data
##' @aliases CC
NULL

##' Simulated COMPASS fit
##'
##' This dataset represents the result of fitting the \code{COMPASS} model on the
##' accompanying dataset \acronym{CC}, as exported by \code{data(COMPASS)}.
##' Please see the vignette (\code{vignette("COMPASS")}) for more details on
##' how to interact with a \code{COMPASS} fit.
##'
##' The model is fit as follows, using the \code{COMPASSContainer}
##' \code{\link{CC}}.
##'
##' \preformatted{
##' CR <- COMPASS(CC,
##'   treatment=trt == "Treatment",
##'   control=trt == "Control",
##'   iterations=1000
##' )
##' }
##'
##' The dataset is exported as \acronym{CR}, which is a short alias
##' for \strong{C}\code{OMPASS}\strong{R}\code{esult}.
##'
##' Please see \code{\link{COMPASS}} for more information on the output from
##' a \code{COMPASS} model fit.
##'
##' @docType data
##' @name COMPASSResult-data
##' @aliases CR
NULL
