% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{getGammaPVal}
\alias{getGammaPVal}
\title{Get a p-value for region set scores based on a gamma distribution.}
\usage{
getGammaPVal(
  rsScores,
  nullDistList,
  signalCol,
  method = "mme",
  realScoreInDist = TRUE,
  force = FALSE
)
}
\arguments{
\item{rsScores}{data.frame. A data.frame with region set
scores. The output of the 'aggregateSignalGRList' function.
Each row is a region set. One column for each sample
variable of interest (e.g. PC or sample phenotype).
Also can have columns with info on the overlap between the 
region set and the epigenetic data. 
Rows should be in the same order as the region sets in GRList
(the list of region sets used to create rsScores.)}

\item{nullDistList}{list of data.frames. Each list item 
has null distributions for a single 
region set (list items should be in the same order as rows of rsScores). 
Has same score columns as rsScores. 
Each column corresponds to a null distribution for that 
region set for a given sample variable of interest/target variable
(e.g. PC or sample phenotype).}

\item{signalCol}{A character vector with the names of the sample variables
of interest/target variables (e.g. PCs or sample phenotypes). 
Must be column names of rsScores.}

\item{method}{Character. Has the method to use to fit the gamma 
distribution to the null distribution.
Options are 
"mme" (moment matching estimation), "mle" (maximum likelihood estimation), 
"qme" (quantile matching estimation), and "mge" (maximum goodness-of-fit 
estimation). See ?fitdistrplus::fitdist() for
available options and meaning.}

\item{realScoreInDist}{logical. Should the actual score (from 
test with no permutations) be included in the null distribution 
when fitting the gamma distribution. realScoreInDist=TRUE is 
recommended.}

\item{force}{logical. If force=TRUE, when fitting the gamma distribution
returns an error (as may happen when a method other than "mme"
is used) then allow the error. If force=FALSE, when fitting the 
gamma distribution returns an error then don't return an error but 
instead use the "mme" method
for fitting that specific gamma distribution.}
}
\value{
Returns a data.frame with p values, one column for each signalCol in
rsScores
}
\description{
First fit a gamma distribution to each region set's null distribution/s
(nullDistList). Then use this gamma distribution to convert scores in
rsScores to p-values.
}
\examples{

}
