% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{convertToFromNullDist}
\alias{convertToFromNullDist}
\title{Converts COCOA permutation results to null distributions and vice versa}
\usage{
convertToFromNullDist(rsScoresList)
}
\arguments{
\item{rsScoresList}{each item in the list is a data.frame, one item for
each permutation with the results of that permutation. Each row in the 
data.frame is a region set. All data.frames should be the same size and
each data.frame's rows should be in the same order}
}
\value{
a list of data.frames. If given a list where each item is 
a data.frame with results from one COCOA permutation, this function
will return a list of data.frames where each data.frame contains the
null distributions for a single region set. The output data.frames will
have the same columns as the input data.frames. If given a list where each
item is a data.frame with the null distribution/s for a single region
set, this function will return a list where each item is a data.frame
with one row for each region set (e.g. a data.frame with results for
a single COCOA permutation).
}
\description{
This function will take a list of results of permutation tests that included
many region sets and return a list of data.frames where each data.frame
contains the null distribution for a single region set.
The function can 
also convert in the reverse order from a list of null distributions to a 
list of COCOA results.
}
\examples{
# six region sets (rows), 2 signals (columns)
fakePermScores <- data.frame(abs(rnorm(6)), abs(rnorm(6)))
fakePermScores2 <- data.frame(abs(rnorm(6)), abs(rnorm(6)))
# 2 fake COCOA results (i.e. nPerm=2)
permRSScores <- list(fakePermScores, fakePermScores2)
convertToFromNullDist(permRSScores)

}
