% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScoringModel.R
\name{plotScoringModel}
\alias{plotScoringModel}
\title{plotVariantsForCNV}
\usage{
plotScoringModel(
  expected.ht.mean,
  expected.dup.ht.mean1,
  expected.dup.ht.mean2,
  sigmoid.c1,
  sigmoid.c2.vector
)
}
\arguments{
\item{expected.ht.mean}{Expected heterozygous SNV/indel allele frequency}

\item{expected.dup.ht.mean1}{Expected heterozygous SNV/indel allele frequency when the variant IS NOT in the same allele than the CNV duplication call}

\item{expected.dup.ht.mean2}{Expected heterozygous SNV/indel allele frequency when the variant IS in the same allele than the CNV duplication call}

\item{sigmoid.c1}{Sigmoid c1 parameter}

\item{sigmoid.c2.vector}{Vector containing sigmoid c2 parameters for the six sigmoids functions}
}
\value{
nothing
}
\description{
Plots scoring model used for CNV duplications
}
\examples{
# Load CNVs data
cnvs.file <- system.file("extdata", "DECoN.CNVcalls.csv", package = "CNVfilteR", mustWork = TRUE)
cnvs.gr <- loadCNVcalls(cnvs.file = cnvs.file, chr.column = "Chromosome", start.column = "Start", end.column = "End", cnv.column = "CNV.type", sample.column = "Sample")

# Load VCFs data
vcf.files <- c(system.file("extdata", "variants.sample1.vcf.gz", package = "CNVfilteR", mustWork = TRUE),
               system.file("extdata", "variants.sample2.vcf.gz", package = "CNVfilteR", mustWork = TRUE))
vcfs <- loadVCFs(vcf.files, cnvs.gr = cnvs.gr)

# Filter CNVs
results <- filterCNVs(cnvs.gr, vcfs)

# Plot scoring model for duplication CNVs
p <- results$filterParameters
plotScoringModel(expected.ht.mean = p$expected.ht.mean, expected.dup.ht.mean1 = p$expected.dup.ht.mean1,
                  expected.dup.ht.mean2 = p$expected.dup.ht.mean2, sigmoid.c1 = p$sigmoid.c1, sigmoid.c2.vector = p$sigmoid.c2.vector)

}
