% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{CDI_lineplot}
\alias{CDI_lineplot}
\title{Visualize CDI values via a lineplot}
\usage{
CDI_lineplot(
  cdi_dataframe,
  cdi_type,
  benchmark_celltype_cdi = NULL,
  benchmark_celltype_ncluster = NULL,
  benchmark_maintype_cdi = NULL,
  benchmark_maintype_ncluster = NULL,
  clustering_method = NULL,
  show_axis_names = TRUE,
  show_method_legend = TRUE
)
}
\arguments{
\item{cdi_dataframe}{A data frame of CDI values. Each row represents one clustering 
method and the number of clusters combination. The columns include "Cluster_method", 
"CDI_AIC", "CDI_BIC", and "N_cluster".}

\item{cdi_type}{A string indication the type of CDI. It can be either "CDI_AIC" or "CDI_BIC".}

\item{benchmark_celltype_cdi}{A list of the output from the CalculateCDI function 
on the benchmark cell type label set. Default is null.}

\item{benchmark_celltype_ncluster}{A number indicating the number of cell types 
in the benchmark cell type label set. Default is null.}

\item{benchmark_maintype_cdi}{A list of the output from the CalculateCDI function 
on the benchmark main type label set. Default is null.}

\item{benchmark_maintype_ncluster}{A number indicating the number of cell types 
in the benchmark main type label set. Default is null.}

\item{clustering_method}{A vector of characters indicating the corresponding clustering 
method for each label set. If this is provided, the 
lineplot will be colored differently by different clustering methods. 
This color scheme can also be obtained if the column names in 
candidate_label_dataframe of CalculateCDI are provided 
with the form "[ClusteringMethod]_k[NumberOfClusters]" such as "KMeans_k5".}

\item{show_axis_names}{A bool value indicating whether the axis names should be shown or not in the plot.}

\item{show_method_legend}{A bool value indicating whether the legend of methods should be shown or not in the plot.}
}
\value{
A ggplot object.
}
\description{
This function visualize CDI outputs with a lineplot. 
The x-axis is for the number of clusters. 
The y-axis is for the CDI values. 
Different colors represent different clustering methods.
The red triangle represents the optimal clustering result corresponding to the smallest CDI value. 
The purple star represents the CDI value for the benchmark (main) cell type label set. 
he brown star represents the CDI value for the benchmark sub-type label set.
}
\examples{
## This data frame is generated here for demonstration only:
CDI_return <- data.frame(
Cluster_method = c("HC", "HC",  "HC", "KMeans", "KMeans", "KMeans"),
N_cluster = c(2,4,6,2,4,6),
CDI_AIC = c(150, 200, 250, 220, 160, 180),
CDI_BIC = c(170, 210, 280, 250, 180, 200))
CDI_lineplot(CDI_return, cdi_type = "CDI_AIC")
benchmark_cdi_return <- list(CDI_AIC = 150, CDI_BIC = 170)
benchmark_ncelltype <- 3
CDI_lineplot(CDI_return, 
            cdi_type = "CDI_AIC", 
            benchmark_celltype_cdi = benchmark_cdi_return, 
            benchmark_celltype_ncluster = benchmark_ncelltype)
}
