% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_heatmap.R
\name{cc_heatmap}
\alias{cc_heatmap}
\title{Heatmap Function}
\usage{
cc_heatmap(cc_df, option = "A", n_top_ints = 30)
}
\arguments{
\item{cc_df}{A dataframe with columns 'source', 'target', 'ligand', 'receptor' and 'score'. See \code{toy_data} for example.}

\item{option}{Either 'A', 'B', 'CellPhoneDB' or 'Liana'. Option A will plot the number of interactions between pairs of cell types, option B will plot the top \code{n_top_ints} interactions and their scores. The 'CellPhoneDB' and 'Liana' options will generate a heatmap in the style of these popular tools.}

\item{n_top_ints}{The number of top interactions to plot. Only required for option B.}
}
\value{
Returns a plot generated with the ggplot2 package
}
\description{
This plots a heatmap
}
\examples{
data(toy_data, package = 'CCPlotR')
cc_heatmap(toy_data)
cc_heatmap(toy_data, option = "B", n_top_ints = 10)
cc_heatmap(toy_data, option = "CellPhoneDB")
}
