% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCAFE_convertVCF.R
\name{CCAFE_convertVCF}
\alias{CCAFE_convertVCF}
\title{CCAFE_convertVCF}
\usage{
CCAFE_convertVCF(vcf)
}
\arguments{
\item{vcf}{a Variant Call Format (VCF) file read in using VariantAnnotation
BioConductor package}
}
\value{
a dataframe object with columns Position, RSID, Chromosome, REF,
ALT, beta, SE, AF, OR
}
\description{
Formats information from a VCF object for use in CCAFE methods as follows:
From the rowRanges object: seqnames (chromosome), ranges (position),
From the geno object: ES (effect size of ALT), SE, AF (allele frequency
of ALT)
}
\examples{
library(VariantAnnotation)
library(CCAFE)

# load the data
data("vcf_sample")

# run the method
df_sample <- CCAFE_convertVCF(vcf_sample)
print(head(df_sample))

# can then use in CCAFE methods
# since we have total AF, will use CaseControl_AF
df_sample <- CaseControl_AF(data = df_sample,
                          N_case = 48286,
                          N_control = 250671,
                          OR_colname = "OR",
                          AF_total_colname = "AF")
head(df_sample)
}
\author{
Hayley Wolff (Stoneman), \email{hayley.wolff@cuanschutz.edu}
}
