% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCounts.R
\name{plotCounts}
\alias{plotCounts}
\title{Plot cell counts}
\usage{
plotCounts(x, group_by = "condition", color_by = group_by, prop = FALSE)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{group_by}{character string specifying a non-numeric 
cell metadata column to group by (determines x-axis ticks);
valid values are \code{names(colData(x))}.}

\item{color_by}{character string specifying a non-numeric
cell metadata column to color by (determines grouping of bars);
valid values are \code{names(colData(x))}; NULL for no color.}

\item{prop}{logical specifying whether to plot relative abundances 
(frequencies) for each group rather than total cell counts;
bars will be stacked when \code{prop = TRUE} and dodged otherwise.}
}
\value{
a \code{\link{ggplot}} object.
}
\description{
Barplot of the number of cells measured for each sample.
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)

# plot number of cells per sample, colored by condition
plotCounts(sce, 
  group_by = "sample_id", 
  color_by = "condition")
  
# same as above, but order by patient  
plotCounts(sce, 
  group_by = "patient_id", 
  color_by = "condition")

# total number of cell per patient
plotCounts(sce, 
  group_by = "patient_id", 
  color_by = NULL)

# plot proportion of cells from each patient by condition
plotCounts(sce, 
  prop = TRUE, 
  group_by = "condition", 
  color_by = "patient_id")

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al.  
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
