% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{\code{FlowSOM} clustering & 
\code{ConsensusClusterPlus} metaclustering}
\usage{
cluster(
  x,
  features = "type",
  xdim = 10,
  ydim = 10,
  maxK = 20,
  verbose = TRUE,
  seed = 1
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{features}{a character vector specifying 
which features to use for clustering; valid values are
\code{"type"/"state"} for \code{type/state_markers(x)} 
if \code{rowData(x)$marker_class} have been specified; 
a subset of \code{rownames(x)}; NULL to use all features.}

\item{xdim, ydim}{numeric specifying the grid size of the 
self-orginizing map; passed to \code{\link[FlowSOM]{BuildSOM}}. 
The default 10x10 grid will yield 100 clusters.}

\item{maxK}{numeric specifying the maximum number of 
clusters to evaluate in the metaclustering; passed to 
\code{\link[ConsensusClusterPlus]{ConsensusClusterPlus}}.
The default (\code{maxK = 20}) will yield 2 through 20 metaclusters.}

\item{verbose}{logical. Should information on progress be reported?}

\item{seed}{numeric. Sets the random seed for reproducible results 
in \code{\link[ConsensusClusterPlus]{ConsensusClusterPlus}}.}
}
\value{
a \code{SingleCellEcperiment} with the following newly added data:
\itemize{
\item{\code{colData}\itemize{
\item{\code{cluster_id}:
  each cell's cluster ID as inferred by \code{FlowSOM}. 
  One of 1, ..., \code{xdim}x\code{ydim}.}
}}
\item{\code{rowData}\itemize{
\item{\code{marker_class}: added when previosly unspecified. \code{"type"}
  when an antigen has been used for clustering, otherwise \code{"state"}.}
\item{\code{used_for_clustering}: logical indicating 
  whether an antigen has been used for clustering.}
}}
\item{\code{metadata}\itemize{
\item{\code{SOM_codes}:
  a table with dimensions K x (# cell type markers), 
  where K = \code{xdim} x \code{ydim}. Contains the SOM codes.}
\item{\code{cluster_codes}:
  a table with dimensions K x (\code{maxK} + 1). 
  Contains the cluster codes for all metaclustering.}
\item{\code{delta_area}: 
  a \code{\link{ggplot}} object (see details).}
}}
}
}
\description{
\code{cluster} will first group cells into \code{xdim}x\code{ydim} 
clusters using \pkg{FlowSOM}, and subsequently perform metaclustering 
with \pkg{ConsensusClusterPlus} into 2 through \code{maxK} clusters.
}
\details{
The delta area represents the amount of extra cluster stability gained when 
clustering into k groups as compared to k-1 groups. It can be expected that 
high stability of clusters can be reached when clustering into the number of 
groups that best fits the data. The "natural" number of clusters present in 
the data should thus corresponds to the value of k where there is no longer 
a considerable increase in stability (pleateau onset).
}
\examples{
# construct SCE
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)

# run clustering
(sce <- cluster(sce))

# view all available clustering
names(cluster_codes(sce))

# access specific clustering resolution
table(cluster_ids(sce, "meta8"))

# view delta area plot
delta_area(sce)

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
