% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptSpillmat.R
\name{adaptSpillmat}
\alias{adaptSpillmat}
\title{Adapt spillover matrix}
\usage{
adaptSpillmat(
  x,
  out_chs,
  isotope_list = CATALYST::isotope_list,
  verbose = TRUE
)
}
\arguments{
\item{x}{a previously calculated spillover matrix.}

\item{out_chs}{the column names that the prepared output 
spillover matrix should have. Numeric names as well as names 
of the form MetalMass(Di), e.g. Ir191, Ir191Di or Ir191(Di), 
will be interpreted as masses with associated metals.}

\item{isotope_list}{named list. Used to validate the input spillover matrix.
Names should be metals; list elements numeric vectors of their isotopes.
See \code{\link{isotope_list}} for the list of isotopes used by default.}

\item{verbose}{logical. Should warnings about possibly 
inaccurate spillover estimates be printed to the console?}
}
\value{
An adapted spillover matrix with 
column and row names according to \code{out_chs}.
}
\description{
This helper function adapts the columns of a provided spillover matrix 
such that it is compatible with data having the column names provided.
}
\details{
The rules how the spillover matrix is adapted 
are explained in \code{\link{compCytof}}.
}
\examples{
# estimate spillover matrix from 
# single-stained control samples
data(ss_exp)
sce <- prepData(ss_exp)
bc_ms <- c(139, 141:156, 158:176)
sce <- assignPrelim(sce, bc_ms, verbose = FALSE)
sce <- applyCutoffs(estCutoffs(sce))
sce <- computeSpillmat(sce)

library(SingleCellExperiment)
sm1 <- metadata(sce)$spillover_matrix
sm2 <- adaptSpillmat(sm1, rownames(sce), verbose = FALSE)
all(dim(sm2) == ncol(sm1))

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch} 
& Vito RT Zanotelli
}
