% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tuneTagClustering}
\alias{tuneTagClustering}
\alias{tuneTagClustering,GRanges-method}
\alias{tuneTagClustering,RangedSummarizedExperiment-method}
\alias{tuneTagClustering,GPos-method}
\title{Determine the optimal pooled threshold for unidirectional tag clustering.}
\usage{
tuneTagClustering(object, ...)

\S4method{tuneTagClustering}{GRanges}(
  object,
  steps = 10L,
  mergeDist = 20L,
  searchMethod = "minUnique",
  maxExponent = 1
)

\S4method{tuneTagClustering}{RangedSummarizedExperiment}(object, ...)

\S4method{tuneTagClustering}{GPos}(object, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: Pooled CTSS.}

\item{...}{additional arguments passed to methods.}

\item{steps}{integer: Number of thresholds to analyze (in addition to
treshold=0).}

\item{mergeDist}{integer: Merge TCs within this distance.}

\item{searchMethod}{character: For advanced user only, see details.}

\item{maxExponent}{numeric: The maximal threshold to analyse is obtained as
min(score)*2^maxExponent (only used if searchMethod='exponential').}
}
\value{
data.frame with two columns: threshold and nTCs (number of Tag
  Clusters)
}
\description{
This function counts the number of Tag Clusters (TCs) for an series of small
incremental pooled cutoffs
}
\examples{
\dontrun{
data(exampleCTSSs)

# Calculate pooledTPM, using supplied number of total tags
exampleCTSSs <- calcTPM(exampleCTSSs,
                        inputAssay='counts',
                        outputAssay='TPM',
                        totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs, inputAssay='TPM')

# Set backend
library(BiocParallel)
register(SerialParam())

# Find optimal slice-threshold for reduce distance of 20:
tuneTagClustering(object=exampleCTSSs)
}
}
\seealso{
Other Clustering functions: 
\code{\link{clusterBidirectionally}()},
\code{\link{clusterUnidirectionally}()},
\code{\link{trimToPeak}()},
\code{\link{trimToPercentiles}()}
}
\concept{Clustering functions}
