% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swap.R
\name{swapScores}
\alias{swapScores}
\title{Swap scores in SummarizedExperiment}
\usage{
swapScores(object, outputColumn = "score", inputAssay, sample)
}
\arguments{
\item{object}{SummarizedExperiment: CAGE-data}

\item{outputColumn}{character: Column in rowData to to hold swapped in
scores.}

\item{inputAssay}{character: Name of assay to take scores from.}

\item{sample}{character: Name of sample to take scores from.}
}
\value{
SummarizedExperiment with sample scores from inputAssay in rowRata.
}
\description{
Take scores for a specific sample and a specific assay and put them into
rowData.
}
\examples{
data(exampleCTSSs)
sample_names <- colnames(exampleCTSSs)

# Replace scores with values from the first sample:
x <- swapScores(exampleCTSSs, inputAssay='counts', sample=sample_names[1])
rowRanges(x)
}
\seealso{
Other Swapping functions: 
\code{\link{swapRanges}()}
}
\concept{Swapping functions}
