% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhancers.R
\name{subsetByBidirectionality}
\alias{subsetByBidirectionality}
\alias{subsetByBidirectionality,GRanges-method}
\alias{subsetByBidirectionality,GPos-method}
\alias{subsetByBidirectionality,RangedSummarizedExperiment-method}
\title{Subset by sample-wise bidirectionality of clusters.}
\usage{
subsetByBidirectionality(object, ...)

\S4method{subsetByBidirectionality}{GRanges}(
  object,
  samples,
  inputAssay = "counts",
  outputColumn = "bidirectionality",
  minSamples = 0
)

\S4method{subsetByBidirectionality}{GPos}(object, ...)

\S4method{subsetByBidirectionality}{RangedSummarizedExperiment}(object, ...)
}
\arguments{
\item{object}{GRanges or RangedSummarizedExperiment: Unstranded clusters with
peaks stored in the 'thick' column.}

\item{...}{additional arguments passed to methods.}

\item{samples}{RangedSummarizedExperiment: Sample-wise CTSSs stored as an
assay.}

\item{inputAssay}{character: Name of assay in samples holding input CTSS
values.}

\item{outputColumn}{character: Name of column in object to hold
bidirectionality values.}

\item{minSamples}{integer: Only regions with bidirectionality above this
value are retained.}
}
\value{
object with bidirectionality values added as a column, and low
  bidirectionaly regions removed.
}
\description{
A convenient wrapper around calcBidirectionality and subset.
}
\examples{
data(exampleCTSSs)
data(exampleBidirectional)

# Keep only clusters that are bidirectional in at least one sample:
subsetByBidirectionality(exampleBidirectional, samples=exampleCTSSs)
}
\seealso{
Other Subsetting functions: 
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}

Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
\concept{Subsetting functions}
