% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.R
\name{quantifyCTSSs2}
\alias{quantifyCTSSs2}
\title{Quantify CAGE Transcriptions Start Sites (CTSSs)}
\usage{
quantifyCTSSs2(
  plusStrand,
  minusStrand,
  design = NULL,
  genome = NULL,
  tileWidth = 100000000L
)
}
\arguments{
\item{plusStrand}{BigWigFileList: BigWig files with plus-strand CTSS data.}

\item{minusStrand}{BigWigFileList: BigWig files with minus-strand CTSS data.}

\item{design}{DataFrame or data.frame: Additional information on samples.}

\item{genome}{Seqinfo: Genome information. If NULL the smallest common genome
will be found using bwCommonGenome.}

\item{tileWidth}{integer: Size of tiles to parallelize over.}
}
\value{
RangedSummarizedExperiment, where assay is a sparse matrix
  (dgCMatrix) of CTSS counts..
}
\description{
This function reads in CTSS count data from a series of BigWig-files and
returns a CTSS-by-library count matrix. For efficient processing, the count
matrix is stored as a sparse matrix (dgCMatrix).
}
\examples{
\dontrun{
# Load the example data
data('exampleDesign')
# Use the BigWig-files included with the package:
bw_plus <- system.file('extdata', exampleDesign$BigWigPlus,
                       package = 'CAGEfightR')
bw_minus <- system.file('extdata', exampleDesign$BigWigMinus,
                        package = 'CAGEfightR')

# Create two named BigWigFileList-objects:
bw_plus <- BigWigFileList(bw_plus)
bw_minus <- BigWigFileList(bw_minus)
names(bw_plus) <- exampleDesign$Name
names(bw_minus) <- exampleDesign$Name

# Quantify CTSSs, by default this will use the smallest common genome:
CTSSs <- quantifyCTSSs(plusStrand=bw_plus,
                       minusStrand=bw_minus,
                       design=exampleDesign)

# Alternatively, a genome can be specified:
si <- seqinfo(bw_plus[[1]])
si <- si['chr18']
CTSSs <- quantifyCTSSs(plusStrand=bw_plus,
                       minusStrand=bw_minus,
                       design=exampleDesign,
                       genome=si)

# Quantification can be speed up by using multiple cores:
library(BiocParallel)
register(MulticoreParam(workers=3))
CTSSs <- quantifyCTSSs(plusStrand=bw_plus,
                       minusStrand=bw_minus,
                       design=exampleDesign,
                       genome=si)
}
}
\seealso{
Other Quantification functions: 
\code{\link{quantifyCTSSs}()},
\code{\link{quantifyClusters}()},
\code{\link{quantifyGenes}()}
}
\concept{Quantification functions}
