% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{findStretches}
\alias{findStretches}
\alias{findStretches,GRanges-method}
\alias{findStretches,RangedSummarizedExperiment-method}
\title{Find stretches of clusters}
\usage{
findStretches(object, ...)

\S4method{findStretches}{GRanges}(object, mergeDist = 10000L, minSize = 3L)

\S4method{findStretches}{RangedSummarizedExperiment}(
  object,
  inputAssay,
  mergeDist = 10000L,
  minSize = 3L,
  corFun = cor,
  ...
)
}
\arguments{
\item{object}{GRanges or RangedSummarizedExperiment: Clusters, possibly with
expression for calculating correlations.}

\item{...}{additional arguments passed to methods or ultimately corFun.}

\item{mergeDist}{integer: Maximum distance between clusters to be merged into
stretches.}

\item{minSize}{integer: Minimum number of clusters in stretches.}

\item{inputAssay}{character: Name of assay holding expression values (if
object is a RangedSummarizedExperiment)}

\item{corFun}{function: Function for calculating correlations. Should behave
and produce output similar to cor().}
}
\value{
A GRanges containing stretches with number of clusters and average
  pairwise correlations calculated. The revmap can be used to retrieve the
  original clusters (see example below.)
}
\description{
Finds stretches or groups of clusters along the genome, where each cluster is
within a certain distance of the next. Once stretches have been identified,
the average pairwise correlation between all clusters in the stretch is
calculated. A typical use case is to look for stretches of enhancers, often
refered to as "super enhancers".
}
\examples{
# Calculate TPM values for bidirectional clusters
data(exampleBidirectional)
BCs <- calcTPM(exampleBidirectional)

# Find stretches
pearson_stretches <- findStretches(BCs, inputAssay="TPM")

# Use Kendall instead of pearson and require bigger stretches
kendall_stretches <- findStretches(BCs, inputAssay="TPM",
                                   minSize=5, method="kendall")

# Use the revmap to get stretches as a GRangesList
grl <- extractList(rowRanges(BCs), kendall_stretches$revmap)
names(grl) <- names(kendall_stretches)
}
\seealso{
Other Spatial functions: 
\code{\link{findLinks}()},
\code{\link{trackLinks}()}
}
\concept{Spatial functions}
